/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.testfilter;

import io.qameta.allure.internal.shadowed.jackson.databind.DeserializationFeature;
import io.qameta.allure.internal.shadowed.jackson.databind.ObjectMapper;
import io.qameta.allure.testfilter.TestPlan;
import io.qameta.allure.testfilter.TestPlanSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTestPlanSupplier
implements TestPlanSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTestPlanSupplier.class);
    private static final String[] ENV_TESTPLAN_PATH = new String[]{"ALLURE_TESTPLAN_PATH", "AS_TESTPLAN_PATH"};
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

    @Override
    public Optional<TestPlan> supply() {
        Optional<String> testPlanPath = Arrays.stream(ENV_TESTPLAN_PATH).map(System::getenv).filter(Objects::nonNull).filter(s -> !s.isEmpty()).findFirst();
        return testPlanPath.flatMap(this::tryGetPath).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).flatMap(this::readTestPlan);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<TestPlan> readTestPlan(Path path) {
        try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
            Optional<Object> optional = Optional.of(OBJECT_MAPPER.readValue(stream, TestPlan.class));
            return optional;
        }
        catch (IOException e) {
            LOGGER.warn("could not read test plan file {}", (Object)path, (Object)e);
            return Optional.empty();
        }
    }

    private Optional<Path> tryGetPath(String path) {
        try {
            return Optional.of(Paths.get(path, new String[0]));
        }
        catch (Exception e) {
            LOGGER.warn("could not read test plan file {}: invalid path", (Object)path);
            return Optional.empty();
        }
    }
}

