/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.testfilter;

import io.qameta.allure.internal.shadowed.jackson.databind.DeserializationFeature;
import io.qameta.allure.internal.shadowed.jackson.databind.ObjectMapper;
import io.qameta.allure.testfilter.TestPlan;
import io.qameta.allure.testfilter.TestPlanSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTestPlanSupplier
implements TestPlanSupplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTestPlanSupplier.class);
    private static final String[] ENV_TESTPLAN_PATH = new String[]{"ALLURE_TESTPLAN_PATH", "AS_TESTPLAN_PATH"};
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

    @Override
    public Optional<TestPlan> supply() {
        Optional<String> testPlanPath = Arrays.stream(ENV_TESTPLAN_PATH).map(System::getenv).filter(Objects::nonNull).filter(s -> !s.isEmpty()).findFirst();
        return testPlanPath.flatMap(this::tryGetPath).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).flatMap(this::readTestPlan);
    }

    private Optional<TestPlan> readTestPlan(Path path) {
        Optional<TestPlan> optional;
        block8: {
            InputStream stream = Files.newInputStream(path, new OpenOption[0]);
            try {
                optional = Optional.of((TestPlan)OBJECT_MAPPER.readValue(stream, TestPlan.class));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.warn("could not read test plan file {}", (Object)path, (Object)e);
                    return Optional.empty();
                }
            }
            stream.close();
        }
        return optional;
    }

    private Optional<Path> tryGetPath(String path) {
        try {
            return Optional.of(Paths.get(path, new String[0]));
        }
        catch (Exception e) {
            LOGGER.warn("could not read test plan file {}: invalid path", (Object)path);
            return Optional.empty();
        }
    }
}

