/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import rx.Notification;
import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;

public final class BlockingOperatorLatest {
    private BlockingOperatorLatest() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Iterable<T> latest(final Observable<? extends T> source) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                LatestObserverIterator lio = new LatestObserverIterator();
                source.materialize().subscribe(lio);
                return lio;
            }
        };
    }

    static final class LatestObserverIterator<T>
    extends Subscriber<Notification<? extends T>>
    implements Iterator<T> {
        final Semaphore notify = new Semaphore(0);
        volatile Notification<? extends T> value;
        static final AtomicReferenceFieldUpdater<LatestObserverIterator, Notification> REFERENCE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(LatestObserverIterator.class, Notification.class, "value");
        Notification<? extends T> iNotif;

        LatestObserverIterator() {
        }

        @Override
        public void onNext(Notification<? extends T> args) {
            boolean wasntAvailable;
            boolean bl = wasntAvailable = REFERENCE_UPDATER.getAndSet(this, args) == null;
            if (wasntAvailable) {
                this.notify.release();
            }
        }

        @Override
        public void onError(Throwable e) {
        }

        @Override
        public void onCompleted() {
        }

        @Override
        public boolean hasNext() {
            if (this.iNotif != null && this.iNotif.isOnError()) {
                throw Exceptions.propagate(this.iNotif.getThrowable());
            }
            if (!(this.iNotif != null && this.iNotif.isOnCompleted() || this.iNotif != null)) {
                Notification n;
                try {
                    this.notify.acquire();
                }
                catch (InterruptedException ex) {
                    this.unsubscribe();
                    Thread.currentThread().interrupt();
                    this.iNotif = Notification.createOnError(ex);
                    throw Exceptions.propagate(ex);
                }
                this.iNotif = n = (Notification)REFERENCE_UPDATER.getAndSet(this, null);
                if (this.iNotif.isOnError()) {
                    throw Exceptions.propagate(this.iNotif.getThrowable());
                }
            }
            return !this.iNotif.isOnCompleted();
        }

        @Override
        public T next() {
            if (this.hasNext() && this.iNotif.isOnNext()) {
                T v = this.iNotif.getValue();
                this.iNotif = null;
                return v;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-only iterator.");
        }
    }
}

