/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.annotations.Experimental;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;

@Experimental
public final class CompletableDetach
extends Completable {
    final CompletableSource source;

    public CompletableDetach(CompletableSource source) {
        this.source = source;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe(new DetachCompletableObserver(observer));
    }

    static final class DetachCompletableObserver
    implements CompletableObserver,
    Disposable {
        CompletableObserver actual;
        Disposable d;

        DetachCompletableObserver(CompletableObserver actual) {
            this.actual = actual;
        }

        @Override
        public void dispose() {
            this.actual = null;
            this.d.dispose();
            this.d = DisposableHelper.DISPOSED;
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onError(Throwable e) {
            this.d = DisposableHelper.DISPOSED;
            CompletableObserver a = this.actual;
            if (a != null) {
                this.actual = null;
                a.onError(e);
            }
        }

        @Override
        public void onComplete() {
            this.d = DisposableHelper.DISPOSED;
            CompletableObserver a = this.actual;
            if (a != null) {
                this.actual = null;
                a.onComplete();
            }
        }
    }
}

