/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.processors.UnicastProcessor;
import io.reactivex.subscribers.SerializedSubscriber;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableWindowTimed<T>
extends AbstractFlowableWithUpstream<T, Flowable<T>> {
    final long timespan;
    final long timeskip;
    final TimeUnit unit;
    final Scheduler scheduler;
    final long maxSize;
    final int bufferSize;
    final boolean restartTimerOnMaxSize;

    public FlowableWindowTimed(Flowable<T> source, long timespan, long timeskip, TimeUnit unit, Scheduler scheduler, long maxSize, int bufferSize, boolean restartTimerOnMaxSize) {
        super(source);
        this.timespan = timespan;
        this.timeskip = timeskip;
        this.unit = unit;
        this.scheduler = scheduler;
        this.maxSize = maxSize;
        this.bufferSize = bufferSize;
        this.restartTimerOnMaxSize = restartTimerOnMaxSize;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Flowable<T>> s) {
        SerializedSubscriber<? super Flowable<T>> actual = new SerializedSubscriber<Flowable<T>>(s);
        if (this.timespan == this.timeskip) {
            if (this.maxSize == Long.MAX_VALUE) {
                this.source.subscribe(new WindowExactUnboundedSubscriber(actual, this.timespan, this.unit, this.scheduler, this.bufferSize));
                return;
            }
            this.source.subscribe(new WindowExactBoundedSubscriber(actual, this.timespan, this.unit, this.scheduler, this.bufferSize, this.maxSize, this.restartTimerOnMaxSize));
            return;
        }
        this.source.subscribe(new WindowSkipSubscriber(actual, this.timespan, this.timeskip, this.unit, this.scheduler.createWorker(), this.bufferSize));
    }

    static final class WindowSkipSubscriber<T>
    extends QueueDrainSubscriber<T, Object, Flowable<T>>
    implements Subscription,
    Runnable {
        final long timespan;
        final long timeskip;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final int bufferSize;
        final List<UnicastProcessor<T>> windows;
        Subscription s;
        volatile boolean terminated;

        WindowSkipSubscriber(Subscriber<? super Flowable<T>> actual, long timespan, long timeskip, TimeUnit unit, Scheduler.Worker worker, int bufferSize) {
            super(actual, new MpscLinkedQueue());
            this.timespan = timespan;
            this.timeskip = timeskip;
            this.unit = unit;
            this.worker = worker;
            this.bufferSize = bufferSize;
            this.windows = new LinkedList<UnicastProcessor<T>>();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                if (this.cancelled) {
                    return;
                }
                long r = this.requested();
                if (r != 0L) {
                    UnicastProcessor w = UnicastProcessor.create(this.bufferSize);
                    this.windows.add(w);
                    this.actual.onNext(w);
                    if (r != Long.MAX_VALUE) {
                        this.produced(1L);
                    }
                    this.worker.schedule(new Completion(w), this.timespan, this.unit);
                    this.worker.schedulePeriodically(this, this.timeskip, this.timeskip, this.unit);
                    s.request(Long.MAX_VALUE);
                } else {
                    s.cancel();
                    this.actual.onError((Throwable)new MissingBackpressureException("Could not emit the first window due to lack of requests"));
                }
            }
        }

        public void onNext(T t) {
            if (this.fastEnter()) {
                for (UnicastProcessor<T> w : this.windows) {
                    w.onNext(t);
                }
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                this.queue.offer(t);
                if (!this.enter()) {
                    return;
                }
            }
            this.drainLoop();
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.actual.onError(t);
            this.dispose();
        }

        public void onComplete() {
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.actual.onComplete();
            this.dispose();
        }

        public void request(long n) {
            this.requested(n);
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void dispose() {
            this.worker.dispose();
        }

        void complete(UnicastProcessor<T> w) {
            this.queue.offer(new SubjectWork<T>(w, false));
            if (this.enter()) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            SimplePlainQueue q = this.queue;
            Subscriber a = this.actual;
            List<UnicastProcessor<T>> ws = this.windows;
            int missed = 1;
            block0: while (true) {
                if (this.terminated) {
                    this.s.cancel();
                    this.dispose();
                    q.clear();
                    ws.clear();
                    return;
                }
                boolean d = this.done;
                Object v = q.poll();
                boolean empty = v == null;
                boolean sw = v instanceof SubjectWork;
                if (d && (empty || sw)) {
                    q.clear();
                    Throwable e = this.error;
                    if (e != null) {
                        for (UnicastProcessor<T> w : ws) {
                            w.onError(e);
                        }
                    } else {
                        for (UnicastProcessor<T> w : ws) {
                            w.onComplete();
                        }
                    }
                    ws.clear();
                    this.dispose();
                    return;
                }
                if (!empty) {
                    if (sw) {
                        SubjectWork work = (SubjectWork)v;
                        if (work.open) {
                            if (this.cancelled) continue;
                            long r = this.requested();
                            if (r != 0L) {
                                UnicastProcessor w = UnicastProcessor.create(this.bufferSize);
                                ws.add(w);
                                a.onNext(w);
                                if (r != Long.MAX_VALUE) {
                                    this.produced(1L);
                                }
                                this.worker.schedule(new Completion(w), this.timespan, this.unit);
                                continue;
                            }
                            a.onError((Throwable)new MissingBackpressureException("Can't emit window due to lack of requests"));
                            continue;
                        }
                        ws.remove(work.w);
                        work.w.onComplete();
                        if (!ws.isEmpty() || !this.cancelled) continue;
                        this.terminated = true;
                        continue;
                    }
                    Iterator<UnicastProcessor<T>> iterator = ws.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block0;
                        UnicastProcessor w = iterator.next();
                        w.onNext(v);
                    }
                }
                if ((missed = this.leave(-missed)) == 0) break;
            }
        }

        @Override
        public void run() {
            UnicastProcessor w = UnicastProcessor.create(this.bufferSize);
            SubjectWork sw = new SubjectWork(w, true);
            if (!this.cancelled) {
                this.queue.offer(sw);
            }
            if (this.enter()) {
                this.drainLoop();
            }
        }

        final class Completion
        implements Runnable {
            private final UnicastProcessor<T> processor;

            Completion(UnicastProcessor<T> processor) {
                this.processor = processor;
            }

            @Override
            public void run() {
                WindowSkipSubscriber.this.complete(this.processor);
            }
        }

        static final class SubjectWork<T> {
            final UnicastProcessor<T> w;
            final boolean open;

            SubjectWork(UnicastProcessor<T> w, boolean open) {
                this.w = w;
                this.open = open;
            }
        }
    }

    static final class WindowExactBoundedSubscriber<T>
    extends QueueDrainSubscriber<T, Object, Flowable<T>>
    implements Subscription {
        final long timespan;
        final TimeUnit unit;
        final Scheduler scheduler;
        final int bufferSize;
        final boolean restartTimerOnMaxSize;
        final long maxSize;
        final Scheduler.Worker worker;
        long count;
        long producerIndex;
        Subscription s;
        UnicastProcessor<T> window;
        volatile boolean terminated;
        final SequentialDisposable timer = new SequentialDisposable();

        WindowExactBoundedSubscriber(Subscriber<? super Flowable<T>> actual, long timespan, TimeUnit unit, Scheduler scheduler, int bufferSize, long maxSize, boolean restartTimerOnMaxSize) {
            super(actual, new MpscLinkedQueue());
            this.timespan = timespan;
            this.unit = unit;
            this.scheduler = scheduler;
            this.bufferSize = bufferSize;
            this.maxSize = maxSize;
            this.restartTimerOnMaxSize = restartTimerOnMaxSize;
            this.worker = restartTimerOnMaxSize ? scheduler.createWorker() : null;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                Subscriber a = this.actual;
                a.onSubscribe((Subscription)this);
                if (this.cancelled) {
                    return;
                }
                UnicastProcessor w = UnicastProcessor.create(this.bufferSize);
                this.window = w;
                long r = this.requested();
                if (r != 0L) {
                    a.onNext(w);
                    if (r != Long.MAX_VALUE) {
                        this.produced(1L);
                    }
                } else {
                    this.cancelled = true;
                    s.cancel();
                    a.onError((Throwable)new MissingBackpressureException("Could not deliver initial window due to lack of requests."));
                    return;
                }
                ConsumerIndexHolder consumerIndexHolder = new ConsumerIndexHolder(this.producerIndex, this);
                Disposable d = this.restartTimerOnMaxSize ? this.worker.schedulePeriodically(consumerIndexHolder, this.timespan, this.timespan, this.unit) : this.scheduler.schedulePeriodicallyDirect(consumerIndexHolder, this.timespan, this.timespan, this.unit);
                if (this.timer.replace(d)) {
                    s.request(Long.MAX_VALUE);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onNext(T t) {
            if (this.terminated) {
                return;
            }
            if (this.fastEnter()) {
                UnicastProcessor<T> w = this.window;
                w.onNext(t);
                long c = this.count + 1L;
                if (c >= this.maxSize) {
                    ++this.producerIndex;
                    this.count = 0L;
                    w.onComplete();
                    long r = this.requested();
                    if (r == 0L) {
                        this.window = null;
                        this.s.cancel();
                        this.actual.onError((Throwable)new MissingBackpressureException("Could not deliver window due to lack of requests"));
                        this.dispose();
                        return;
                    }
                    w = UnicastProcessor.create(this.bufferSize);
                    this.window = w;
                    this.actual.onNext(w);
                    if (r != Long.MAX_VALUE) {
                        this.produced(1L);
                    }
                    if (this.restartTimerOnMaxSize) {
                        Disposable tm = (Disposable)this.timer.get();
                        tm.dispose();
                        Disposable task = this.worker.schedulePeriodically(new ConsumerIndexHolder(this.producerIndex, this), this.timespan, this.timespan, this.unit);
                        this.timer.replace(task);
                    }
                } else {
                    this.count = c;
                }
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                this.queue.offer(NotificationLite.next(t));
                if (!this.enter()) {
                    return;
                }
            }
            this.drainLoop();
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.actual.onError(t);
            this.dispose();
        }

        public void onComplete() {
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.actual.onComplete();
            this.dispose();
        }

        public void request(long n) {
            this.requested(n);
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void dispose() {
            DisposableHelper.dispose(this.timer);
            Scheduler.Worker w = this.worker;
            if (w != null) {
                w.dispose();
            }
        }

        void drainLoop() {
            SimplePlainQueue q = this.queue;
            Subscriber a = this.actual;
            UnicastProcessor w = this.window;
            int missed = 1;
            while (true) {
                if (this.terminated) {
                    this.s.cancel();
                    q.clear();
                    this.dispose();
                    return;
                }
                boolean d = this.done;
                Object o = q.poll();
                boolean empty = o == null;
                boolean isHolder = o instanceof ConsumerIndexHolder;
                if (d && (empty || isHolder)) {
                    this.window = null;
                    q.clear();
                    Throwable err = this.error;
                    if (err != null) {
                        w.onError(err);
                    } else {
                        w.onComplete();
                    }
                    this.dispose();
                    return;
                }
                if (!empty) {
                    if (isHolder) {
                        ConsumerIndexHolder consumerIndexHolder = (ConsumerIndexHolder)o;
                        if (!this.restartTimerOnMaxSize && this.producerIndex != consumerIndexHolder.index) continue;
                        w.onComplete();
                        this.count = 0L;
                        w = UnicastProcessor.create(this.bufferSize);
                        this.window = w;
                        long r = this.requested();
                        if (r != 0L) {
                            a.onNext(w);
                            if (r == Long.MAX_VALUE) continue;
                            this.produced(1L);
                            continue;
                        }
                        this.window = null;
                        this.queue.clear();
                        this.s.cancel();
                        a.onError((Throwable)new MissingBackpressureException("Could not deliver first window due to lack of requests."));
                        this.dispose();
                        return;
                    }
                    w.onNext(NotificationLite.getValue(o));
                    long c = this.count + 1L;
                    if (c >= this.maxSize) {
                        ++this.producerIndex;
                        this.count = 0L;
                        w.onComplete();
                        long r = this.requested();
                        if (r != 0L) {
                            w = UnicastProcessor.create(this.bufferSize);
                            this.window = w;
                            this.actual.onNext(w);
                            if (r != Long.MAX_VALUE) {
                                this.produced(1L);
                            }
                            if (!this.restartTimerOnMaxSize) continue;
                            Disposable tm = (Disposable)this.timer.get();
                            tm.dispose();
                            Disposable task = this.worker.schedulePeriodically(new ConsumerIndexHolder(this.producerIndex, this), this.timespan, this.timespan, this.unit);
                            this.timer.replace(task);
                            continue;
                        }
                        this.window = null;
                        this.s.cancel();
                        this.actual.onError((Throwable)new MissingBackpressureException("Could not deliver window due to lack of requests"));
                        this.dispose();
                        return;
                    }
                    this.count = c;
                    continue;
                }
                if ((missed = this.leave(-missed)) == 0) break;
            }
        }

        static final class ConsumerIndexHolder
        implements Runnable {
            final long index;
            final WindowExactBoundedSubscriber<?> parent;

            ConsumerIndexHolder(long index, WindowExactBoundedSubscriber<?> parent) {
                this.index = index;
                this.parent = parent;
            }

            @Override
            public void run() {
                WindowExactBoundedSubscriber<?> p = this.parent;
                if (!((WindowExactBoundedSubscriber)p).cancelled) {
                    ((WindowExactBoundedSubscriber)p).queue.offer(this);
                } else {
                    p.terminated = true;
                    p.dispose();
                }
                if (p.enter()) {
                    p.drainLoop();
                }
            }
        }
    }

    static final class WindowExactUnboundedSubscriber<T>
    extends QueueDrainSubscriber<T, Object, Flowable<T>>
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        final long timespan;
        final TimeUnit unit;
        final Scheduler scheduler;
        final int bufferSize;
        Subscription s;
        UnicastProcessor<T> window;
        final SequentialDisposable timer = new SequentialDisposable();
        static final Object NEXT = new Object();
        volatile boolean terminated;

        WindowExactUnboundedSubscriber(Subscriber<? super Flowable<T>> actual, long timespan, TimeUnit unit, Scheduler scheduler, int bufferSize) {
            super(actual, new MpscLinkedQueue());
            this.timespan = timespan;
            this.unit = unit;
            this.scheduler = scheduler;
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.window = UnicastProcessor.create(this.bufferSize);
                Subscriber a = this.actual;
                a.onSubscribe((Subscription)this);
                long r = this.requested();
                if (r != 0L) {
                    a.onNext(this.window);
                    if (r != Long.MAX_VALUE) {
                        this.produced(1L);
                    }
                } else {
                    this.cancelled = true;
                    s.cancel();
                    a.onError((Throwable)new MissingBackpressureException("Could not deliver first window due to lack of requests."));
                    return;
                }
                if (!this.cancelled && this.timer.replace(this.scheduler.schedulePeriodicallyDirect(this, this.timespan, this.timespan, this.unit))) {
                    s.request(Long.MAX_VALUE);
                }
            }
        }

        public void onNext(T t) {
            if (this.terminated) {
                return;
            }
            if (this.fastEnter()) {
                this.window.onNext(t);
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                this.queue.offer(NotificationLite.next(t));
                if (!this.enter()) {
                    return;
                }
            }
            this.drainLoop();
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.actual.onError(t);
            this.dispose();
        }

        public void onComplete() {
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.actual.onComplete();
            this.dispose();
        }

        public void request(long n) {
            this.requested(n);
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void dispose() {
            DisposableHelper.dispose(this.timer);
        }

        @Override
        public void run() {
            if (this.cancelled) {
                this.terminated = true;
                this.dispose();
            }
            this.queue.offer(NEXT);
            if (this.enter()) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            SimplePlainQueue q = this.queue;
            Subscriber a = this.actual;
            UnicastProcessor w = this.window;
            int missed = 1;
            while (true) {
                boolean term = this.terminated;
                boolean d = this.done;
                Object o = q.poll();
                if (d && (o == null || o == NEXT)) {
                    this.window = null;
                    q.clear();
                    this.dispose();
                    Throwable err = this.error;
                    if (err != null) {
                        w.onError(err);
                    } else {
                        w.onComplete();
                    }
                    return;
                }
                if (o != null) {
                    if (o == NEXT) {
                        w.onComplete();
                        if (!term) {
                            w = UnicastProcessor.create(this.bufferSize);
                            this.window = w;
                            long r = this.requested();
                            if (r != 0L) {
                                a.onNext(w);
                                if (r == Long.MAX_VALUE) continue;
                                this.produced(1L);
                                continue;
                            }
                            this.window = null;
                            this.queue.clear();
                            this.s.cancel();
                            this.dispose();
                            a.onError((Throwable)new MissingBackpressureException("Could not deliver first window due to lack of requests."));
                            return;
                        }
                        this.s.cancel();
                        continue;
                    }
                    w.onNext(NotificationLite.getValue(o));
                    continue;
                }
                if ((missed = this.leave(-missed)) == 0) break;
            }
        }
    }
}

