/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableRefCount<T>
extends Flowable<T> {
    final ConnectableFlowable<T> source;
    final int n;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    RefConnection connection;

    public FlowableRefCount(ConnectableFlowable<T> source) {
        this(source, 1, 0L, TimeUnit.NANOSECONDS, Schedulers.trampoline());
    }

    public FlowableRefCount(ConnectableFlowable<T> source, int n, long timeout, TimeUnit unit, Scheduler scheduler) {
        this.source = source;
        this.n = n;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        RefConnection conn;
        boolean connect = false;
        FlowableRefCount flowableRefCount = this;
        synchronized (flowableRefCount) {
            long c;
            conn = this.connection;
            if (conn == null) {
                this.connection = conn = new RefConnection(this);
            }
            if ((c = conn.subscriberCount) == 0L && conn.timer != null) {
                conn.timer.dispose();
            }
            conn.subscriberCount = c + 1L;
            if (!conn.connected && c + 1L == (long)this.n) {
                connect = true;
                conn.connected = true;
            }
        }
        this.source.subscribe((FlowableSubscriber<? super T>)new RefCountSubscriber<T>(s, this, conn));
        if (connect) {
            this.source.connect(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(RefConnection rc) {
        SequentialDisposable sd;
        FlowableRefCount flowableRefCount = this;
        synchronized (flowableRefCount) {
            long c;
            if (this.connection == null) {
                return;
            }
            rc.subscriberCount = c = rc.subscriberCount - 1L;
            if (c != 0L || !rc.connected) {
                return;
            }
            if (this.timeout == 0L) {
                this.timeout(rc);
                return;
            }
            sd = new SequentialDisposable();
            rc.timer = sd;
        }
        sd.replace(this.scheduler.scheduleDirect(rc, this.timeout, this.unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminated(RefConnection rc) {
        FlowableRefCount flowableRefCount = this;
        synchronized (flowableRefCount) {
            if (this.connection != null) {
                this.connection = null;
                if (rc.timer != null) {
                    rc.timer.dispose();
                }
                if (this.source instanceof Disposable) {
                    ((Disposable)((Object)this.source)).dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timeout(RefConnection rc) {
        FlowableRefCount flowableRefCount = this;
        synchronized (flowableRefCount) {
            if (rc.subscriberCount == 0L && rc == this.connection) {
                this.connection = null;
                DisposableHelper.dispose(rc);
                if (this.source instanceof Disposable) {
                    ((Disposable)((Object)this.source)).dispose();
                }
            }
        }
    }

    static final class RefCountSubscriber<T>
    extends AtomicBoolean
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -7419642935409022375L;
        final Subscriber<? super T> downstream;
        final FlowableRefCount<T> parent;
        final RefConnection connection;
        Subscription upstream;

        RefCountSubscriber(Subscriber<? super T> actual, FlowableRefCount<T> parent, RefConnection connection) {
            this.downstream = actual;
            this.parent = parent;
            this.connection = connection;
        }

        public void onNext(T t) {
            this.downstream.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.compareAndSet(false, true)) {
                this.parent.terminated(this.connection);
                this.downstream.onError(t);
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        public void onComplete() {
            if (this.compareAndSet(false, true)) {
                this.parent.terminated(this.connection);
                this.downstream.onComplete();
            }
        }

        public void request(long n) {
            this.upstream.request(n);
        }

        public void cancel() {
            this.upstream.cancel();
            if (this.compareAndSet(false, true)) {
                this.parent.cancel(this.connection);
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }
        }
    }

    static final class RefConnection
    extends AtomicReference<Disposable>
    implements Runnable,
    Consumer<Disposable> {
        private static final long serialVersionUID = -4552101107598366241L;
        final FlowableRefCount<?> parent;
        Disposable timer;
        long subscriberCount;
        boolean connected;

        RefConnection(FlowableRefCount<?> parent) {
            this.parent = parent;
        }

        @Override
        public void run() {
            this.parent.timeout(this);
        }

        @Override
        public void accept(Disposable t) throws Exception {
            DisposableHelper.replace(this, t);
        }
    }
}

