/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subjects;

import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.NonNull;
import io.reactivex.annotations.Nullable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.Subject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ReplaySubject<T>
extends Subject<T> {
    final ReplayBuffer<T> buffer;
    final AtomicReference<ReplayDisposable<T>[]> observers;
    static final ReplayDisposable[] EMPTY = new ReplayDisposable[0];
    static final ReplayDisposable[] TERMINATED = new ReplayDisposable[0];
    boolean done;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    @CheckReturnValue
    @NonNull
    public static <T> ReplaySubject<T> create() {
        return new ReplaySubject(new UnboundedReplayBuffer(16));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplaySubject<T> create(int capacityHint) {
        return new ReplaySubject(new UnboundedReplayBuffer(capacityHint));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplaySubject<T> createWithSize(int maxSize) {
        return new ReplaySubject(new SizeBoundReplayBuffer(maxSize));
    }

    static <T> ReplaySubject<T> createUnbounded() {
        return new ReplaySubject(new SizeBoundReplayBuffer(Integer.MAX_VALUE));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplaySubject<T> createWithTime(long maxAge, TimeUnit unit, Scheduler scheduler) {
        return new ReplaySubject(new SizeAndTimeBoundReplayBuffer(Integer.MAX_VALUE, maxAge, unit, scheduler));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplaySubject<T> createWithTimeAndSize(long maxAge, TimeUnit unit, Scheduler scheduler, int maxSize) {
        return new ReplaySubject(new SizeAndTimeBoundReplayBuffer(maxSize, maxAge, unit, scheduler));
    }

    ReplaySubject(ReplayBuffer<T> buffer) {
        this.buffer = buffer;
        this.observers = new AtomicReference<ReplayDisposable[]>(EMPTY);
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        ReplayDisposable<? super T> rs = new ReplayDisposable<T>(observer, this);
        observer.onSubscribe(rs);
        if (!rs.cancelled) {
            if (this.add(rs) && rs.cancelled) {
                this.remove(rs);
                return;
            }
            this.buffer.replay(rs);
        }
    }

    @Override
    public void onSubscribe(Disposable d) {
        if (this.done) {
            d.dispose();
        }
    }

    @Override
    public void onNext(T t) {
        ObjectHelper.requireNonNull(t, "onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.done) {
            return;
        }
        ReplayBuffer<T> b = this.buffer;
        b.add(t);
        for (ReplayDisposable<T> rs : this.observers.get()) {
            b.replay(rs);
        }
    }

    @Override
    public void onError(Throwable t) {
        ObjectHelper.requireNonNull(t, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.done = true;
        Object o = NotificationLite.error(t);
        ReplayBuffer<T> b = this.buffer;
        b.addFinal(o);
        for (ReplayDisposable<T> rs : this.terminate(o)) {
            b.replay(rs);
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        Object o = NotificationLite.complete();
        ReplayBuffer<T> b = this.buffer;
        b.addFinal(o);
        for (ReplayDisposable<T> rs : this.terminate(o)) {
            b.replay(rs);
        }
    }

    @Override
    public boolean hasObservers() {
        return this.observers.get().length != 0;
    }

    int observerCount() {
        return this.observers.get().length;
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        Object o = this.buffer.get();
        if (NotificationLite.isError(o)) {
            return NotificationLite.getError(o);
        }
        return null;
    }

    @Nullable
    public T getValue() {
        return this.buffer.getValue();
    }

    public void cleanupBuffer() {
        this.buffer.trimHead();
    }

    public Object[] getValues() {
        Object[] a = EMPTY_ARRAY;
        Object[] b = this.getValues(a);
        if (b == EMPTY_ARRAY) {
            return new Object[0];
        }
        return b;
    }

    public T[] getValues(T[] array) {
        return this.buffer.getValues(array);
    }

    @Override
    public boolean hasComplete() {
        Object o = this.buffer.get();
        return NotificationLite.isComplete(o);
    }

    @Override
    public boolean hasThrowable() {
        Object o = this.buffer.get();
        return NotificationLite.isError(o);
    }

    public boolean hasValue() {
        return this.buffer.size() != 0;
    }

    int size() {
        return this.buffer.size();
    }

    boolean add(ReplayDisposable<T> rs) {
        ReplayDisposable[] b;
        ReplayDisposable<T>[] a;
        do {
            if ((a = this.observers.get()) == TERMINATED) {
                return false;
            }
            int len = a.length;
            b = new ReplayDisposable[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = rs;
        } while (!this.observers.compareAndSet(a, b));
        return true;
    }

    void remove(ReplayDisposable<T> rs) {
        ReplayDisposable[] b;
        ReplayDisposable<T>[] a;
        do {
            if ((a = this.observers.get()) == TERMINATED || a == EMPTY) {
                return;
            }
            int len = a.length;
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != rs) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                b = EMPTY;
                continue;
            }
            b = new ReplayDisposable[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
        } while (!this.observers.compareAndSet(a, b));
    }

    ReplayDisposable<T>[] terminate(Object terminalValue) {
        if (this.buffer.compareAndSet(null, terminalValue)) {
            return this.observers.getAndSet(TERMINATED);
        }
        return TERMINATED;
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    extends AtomicReference<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = -8056260896137901749L;
        final int maxSize;
        final long maxAge;
        final TimeUnit unit;
        final Scheduler scheduler;
        int size;
        volatile TimedNode<Object> head;
        TimedNode<Object> tail;
        volatile boolean done;

        SizeAndTimeBoundReplayBuffer(int maxSize, long maxAge, TimeUnit unit, Scheduler scheduler) {
            this.maxSize = ObjectHelper.verifyPositive(maxSize, "maxSize");
            this.maxAge = ObjectHelper.verifyPositive(maxAge, "maxAge");
            this.unit = ObjectHelper.requireNonNull(unit, "unit is null");
            this.scheduler = ObjectHelper.requireNonNull(scheduler, "scheduler is null");
            TimedNode<Object> h = new TimedNode<Object>(null, 0L);
            this.tail = h;
            this.head = h;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                TimedNode<Object> h = this.head;
                this.head = (TimedNode)h.get();
            }
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode h = this.head;
            while (true) {
                TimedNode next;
                if ((next = (TimedNode)h.get()) == null) {
                    this.head = h;
                    break;
                }
                if (next.time > limit) {
                    this.head = h;
                    break;
                }
                h = next;
            }
        }

        void trimFinal() {
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode h = this.head;
            while (true) {
                TimedNode next;
                if ((next = (TimedNode)h.get()).get() == null) {
                    if (h.value != null) {
                        TimedNode<Object> lasth = new TimedNode<Object>(null, 0L);
                        lasth.lazySet(h.get());
                        this.head = lasth;
                        break;
                    }
                    this.head = h;
                    break;
                }
                if (next.time > limit) {
                    if (h.value != null) {
                        TimedNode<Object> lasth = new TimedNode<Object>(null, 0L);
                        lasth.lazySet(h.get());
                        this.head = lasth;
                        break;
                    }
                    this.head = h;
                    break;
                }
                h = next;
            }
        }

        @Override
        public void add(T value) {
            TimedNode<T> n = new TimedNode<T>(value, this.scheduler.now(this.unit));
            TimedNode<Object> t = this.tail;
            this.tail = n;
            ++this.size;
            t.set(n);
            this.trim();
        }

        @Override
        public void addFinal(Object notificationLite) {
            TimedNode<Object> n = new TimedNode<Object>(notificationLite, Long.MAX_VALUE);
            TimedNode<Object> t = this.tail;
            this.tail = n;
            ++this.size;
            t.lazySet(n);
            this.trimFinal();
            this.done = true;
        }

        @Override
        public void trimHead() {
            TimedNode<Object> h = this.head;
            if (h.value != null) {
                TimedNode<Object> n = new TimedNode<Object>(null, 0L);
                n.lazySet(h.get());
                this.head = n;
            }
        }

        @Override
        @Nullable
        public T getValue() {
            TimedNode next;
            TimedNode prev = null;
            TimedNode h = this.head;
            while ((next = (TimedNode)h.get()) != null) {
                prev = h;
                h = next;
            }
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            if (h.time < limit) {
                return null;
            }
            Object v = h.value;
            if (v == null) {
                return null;
            }
            if (NotificationLite.isComplete(v) || NotificationLite.isError(v)) {
                return prev.value;
            }
            return v;
        }

        TimedNode<Object> getHead() {
            long ts;
            TimedNode index = this.head;
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode next = (TimedNode)index.get();
            while (next != null && (ts = next.time) <= limit) {
                index = next;
                next = (TimedNode)index.get();
            }
            return index;
        }

        @Override
        public T[] getValues(T[] array) {
            TimedNode h = this.getHead();
            int s = this.size(h);
            if (s == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
            } else {
                if (array.length < s) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), s);
                }
                for (int i = 0; i != s; ++i) {
                    TimedNode next = (TimedNode)h.get();
                    array[i] = next.value;
                    h = next;
                }
                if (array.length > s) {
                    array[s] = null;
                }
            }
            return array;
        }

        @Override
        public void replay(ReplayDisposable<T> rs) {
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer a = rs.downstream;
            TimedNode index = (TimedNode)rs.index;
            if (index == null) {
                index = this.getHead();
            }
            while (true) {
                if (rs.cancelled) {
                    rs.index = null;
                    return;
                }
                while (true) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    TimedNode n = (TimedNode)index.get();
                    if (n == null) break;
                    Object o = n.value;
                    if (this.done && n.get() == null) {
                        if (NotificationLite.isComplete(o)) {
                            a.onComplete();
                        } else {
                            a.onError(NotificationLite.getError(o));
                        }
                        rs.index = null;
                        rs.cancelled = true;
                        return;
                    }
                    a.onNext(o);
                    index = n;
                }
                if (index.get() != null) continue;
                rs.index = index;
                if ((missed = rs.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            return this.size(this.getHead());
        }

        int size(TimedNode<Object> h) {
            int s;
            for (s = 0; s != Integer.MAX_VALUE; ++s) {
                TimedNode next = (TimedNode)h.get();
                if (next == null) {
                    Object o = h.value;
                    if (!NotificationLite.isComplete(o) && !NotificationLite.isError(o)) break;
                    --s;
                    break;
                }
                h = next;
            }
            return s;
        }
    }

    static final class SizeBoundReplayBuffer<T>
    extends AtomicReference<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = 1107649250281456395L;
        final int maxSize;
        int size;
        volatile Node<Object> head;
        Node<Object> tail;
        volatile boolean done;

        SizeBoundReplayBuffer(int maxSize) {
            this.maxSize = ObjectHelper.verifyPositive(maxSize, "maxSize");
            Node<Object> h = new Node<Object>(null);
            this.tail = h;
            this.head = h;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                Node<Object> h = this.head;
                this.head = (Node)h.get();
            }
        }

        @Override
        public void add(T value) {
            Node<T> n = new Node<T>(value);
            Node<Object> t = this.tail;
            this.tail = n;
            ++this.size;
            t.set(n);
            this.trim();
        }

        @Override
        public void addFinal(Object notificationLite) {
            Node<Object> n = new Node<Object>(notificationLite);
            Node<Object> t = this.tail;
            this.tail = n;
            ++this.size;
            t.lazySet(n);
            this.trimHead();
            this.done = true;
        }

        @Override
        public void trimHead() {
            Node<Object> h = this.head;
            if (h.value != null) {
                Node<Object> n = new Node<Object>(null);
                n.lazySet(h.get());
                this.head = n;
            }
        }

        @Override
        @Nullable
        public T getValue() {
            Node next;
            Node prev = null;
            Node h = this.head;
            while ((next = (Node)h.get()) != null) {
                prev = h;
                h = next;
            }
            Object v = h.value;
            if (v == null) {
                return null;
            }
            if (NotificationLite.isComplete(v) || NotificationLite.isError(v)) {
                return prev.value;
            }
            return v;
        }

        @Override
        public T[] getValues(T[] array) {
            Node h = this.head;
            int s = this.size();
            if (s == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
            } else {
                if (array.length < s) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), s);
                }
                for (int i = 0; i != s; ++i) {
                    Node next = (Node)h.get();
                    array[i] = next.value;
                    h = next;
                }
                if (array.length > s) {
                    array[s] = null;
                }
            }
            return array;
        }

        @Override
        public void replay(ReplayDisposable<T> rs) {
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer a = rs.downstream;
            Node index = (Node)rs.index;
            if (index == null) {
                index = this.head;
            }
            while (true) {
                if (rs.cancelled) {
                    rs.index = null;
                    return;
                }
                Node n = (Node)index.get();
                if (n != null) {
                    Object o = n.value;
                    if (this.done && n.get() == null) {
                        if (NotificationLite.isComplete(o)) {
                            a.onComplete();
                        } else {
                            a.onError(NotificationLite.getError(o));
                        }
                        rs.index = null;
                        rs.cancelled = true;
                        return;
                    }
                    a.onNext(o);
                    index = n;
                    continue;
                }
                if (index.get() != null) continue;
                rs.index = index;
                if ((missed = rs.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            int s;
            Node h = this.head;
            for (s = 0; s != Integer.MAX_VALUE; ++s) {
                Node next = (Node)h.get();
                if (next == null) {
                    Object o = h.value;
                    if (!NotificationLite.isComplete(o) && !NotificationLite.isError(o)) break;
                    --s;
                    break;
                }
                h = next;
            }
            return s;
        }
    }

    static final class TimedNode<T>
    extends AtomicReference<TimedNode<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;
        final long time;

        TimedNode(T value, long time) {
            this.value = value;
            this.time = time;
        }
    }

    static final class Node<T>
    extends AtomicReference<Node<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;

        Node(T value) {
            this.value = value;
        }
    }

    static final class UnboundedReplayBuffer<T>
    extends AtomicReference<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = -733876083048047795L;
        final List<Object> buffer;
        volatile boolean done;
        volatile int size;

        UnboundedReplayBuffer(int capacityHint) {
            this.buffer = new ArrayList<Object>(ObjectHelper.verifyPositive(capacityHint, "capacityHint"));
        }

        @Override
        public void add(T value) {
            this.buffer.add(value);
            ++this.size;
        }

        @Override
        public void addFinal(Object notificationLite) {
            this.buffer.add(notificationLite);
            this.trimHead();
            ++this.size;
            this.done = true;
        }

        @Override
        public void trimHead() {
        }

        @Override
        @Nullable
        public T getValue() {
            int s = this.size;
            if (s != 0) {
                List<Object> b = this.buffer;
                Object o = b.get(s - 1);
                if (NotificationLite.isComplete(o) || NotificationLite.isError(o)) {
                    if (s == 1) {
                        return null;
                    }
                    return (T)b.get(s - 2);
                }
                return (T)o;
            }
            return null;
        }

        @Override
        public T[] getValues(T[] array) {
            int s = this.size;
            if (s == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
                return array;
            }
            List<Object> b = this.buffer;
            Object o = b.get(s - 1);
            if ((NotificationLite.isComplete(o) || NotificationLite.isError(o)) && --s == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
                return array;
            }
            if (array.length < s) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), s);
            }
            for (int i = 0; i < s; ++i) {
                array[i] = b.get(i);
            }
            if (array.length > s) {
                array[s] = null;
            }
            return array;
        }

        @Override
        public void replay(ReplayDisposable<T> rs) {
            int index;
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            List<Object> b = this.buffer;
            Observer<Object> a = rs.downstream;
            Integer indexObject = (Integer)rs.index;
            if (indexObject != null) {
                index = indexObject;
            } else {
                index = 0;
                rs.index = 0;
            }
            while (true) {
                if (rs.cancelled) {
                    rs.index = null;
                    return;
                }
                int s = this.size;
                while (s != index) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    Object o = b.get(index);
                    if (this.done && index + 1 == s && index + 1 == (s = this.size)) {
                        if (NotificationLite.isComplete(o)) {
                            a.onComplete();
                        } else {
                            a.onError(NotificationLite.getError(o));
                        }
                        rs.index = null;
                        rs.cancelled = true;
                        return;
                    }
                    a.onNext(o);
                    ++index;
                }
                if (index != this.size) continue;
                rs.index = index;
                if ((missed = rs.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            int s = this.size;
            if (s != 0) {
                Object o = this.buffer.get(s - 1);
                if (NotificationLite.isComplete(o) || NotificationLite.isError(o)) {
                    return s - 1;
                }
                return s;
            }
            return 0;
        }
    }

    static final class ReplayDisposable<T>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = 466549804534799122L;
        final Observer<? super T> downstream;
        final ReplaySubject<T> state;
        Object index;
        volatile boolean cancelled;

        ReplayDisposable(Observer<? super T> actual, ReplaySubject<T> state) {
            this.downstream = actual;
            this.state = state;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }
    }

    static interface ReplayBuffer<T> {
        public void add(T var1);

        public void addFinal(Object var1);

        public void replay(ReplayDisposable<T> var1);

        public int size();

        @Nullable
        public T getValue();

        public T[] getValues(T[] var1);

        public Object get();

        public boolean compareAndSet(Object var1, Object var2);

        public void trimHead();
    }
}

