/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.etcd3;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.DeleteResponse;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.kv.PutResponse;
import io.etcd.jetcd.kv.TxnResponse;
import io.etcd.jetcd.op.Cmp;
import io.etcd.jetcd.op.CmpTarget;
import io.etcd.jetcd.op.Op;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.watch.WatchResponse;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ConcurrentSet;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.CollectionUtils;
import io.seata.config.AbstractConfiguration;
import io.seata.config.ConfigFuture;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdConfiguration
extends AbstractConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdConfiguration.class);
    private static volatile EtcdConfiguration instance;
    private static volatile Client client;
    private static final Configuration FILE_CONFIG;
    private static final String SERVER_ADDR_KEY = "serverAddr";
    private static final String CONFIG_TYPE = "etcd3";
    private static final String FILE_CONFIG_KEY_PREFIX = "config.etcd3.";
    private static final int THREAD_POOL_NUM = 1;
    private static final int MAP_INITIAL_CAPACITY = 8;
    private ExecutorService etcdConfigExecutor;
    private ConcurrentMap<String, Set<ConfigurationChangeListener>> configListenersMap = new ConcurrentHashMap<String, Set<ConfigurationChangeListener>>(8);
    private static final long VERSION_NOT_EXIST = 0L;

    private EtcdConfiguration() {
        this.etcdConfigExecutor = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("etcd-config-executor", 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EtcdConfiguration getInstance() {
        if (instance != null) return instance;
        Class<EtcdConfiguration> clazz = EtcdConfiguration.class;
        synchronized (EtcdConfiguration.class) {
            if (instance != null) return instance;
            instance = new EtcdConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String getTypeName() {
        return CONFIG_TYPE;
    }

    @Override
    public String getLatestConfig(String dataId, String defaultValue, long timeoutMills) {
        String value = this.getConfigFromSysPro(dataId);
        if (value != null) {
            return value;
        }
        ConfigFuture configFuture = new ConfigFuture(dataId, defaultValue, ConfigFuture.ConfigOperation.GET, timeoutMills);
        this.etcdConfigExecutor.execute(() -> this.complete(EtcdConfiguration.getClient().getKVClient().get(ByteSequence.from((String)dataId, (Charset)CharsetUtil.UTF_8)), configFuture));
        return (String)configFuture.get();
    }

    @Override
    public boolean putConfig(String dataId, String content, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUT, timeoutMills);
        this.etcdConfigExecutor.execute(() -> this.complete(EtcdConfiguration.getClient().getKVClient().put(ByteSequence.from((String)dataId, (Charset)CharsetUtil.UTF_8), ByteSequence.from((String)content, (Charset)CharsetUtil.UTF_8)), configFuture));
        return (Boolean)configFuture.get();
    }

    @Override
    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUTIFABSENT, timeoutMills);
        this.etcdConfigExecutor.execute(() -> this.complete(client.getKVClient().txn().If(new Cmp[]{new Cmp(ByteSequence.from((String)dataId, (Charset)CharsetUtil.UTF_8), Cmp.Op.EQUAL, (CmpTarget)CmpTarget.version((long)0L))}).Then(new Op[]{Op.put((ByteSequence)ByteSequence.from((String)dataId, (Charset)CharsetUtil.UTF_8), (ByteSequence)ByteSequence.from((String)content, (Charset)CharsetUtil.UTF_8), (PutOption)PutOption.DEFAULT)}).commit(), configFuture));
        return (Boolean)configFuture.get();
    }

    @Override
    public boolean removeConfig(String dataId, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, null, ConfigFuture.ConfigOperation.REMOVE, timeoutMills);
        this.etcdConfigExecutor.execute(() -> this.complete(EtcdConfiguration.getClient().getKVClient().delete(ByteSequence.from((String)dataId, (Charset)CharsetUtil.UTF_8)), configFuture));
        return (Boolean)configFuture.get();
    }

    @Override
    public void addConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (dataId == null || listener == null) {
            return;
        }
        this.configListenersMap.putIfAbsent(dataId, (Set<ConfigurationChangeListener>)new ConcurrentSet());
        EtcdListener etcdListener = new EtcdListener(dataId, listener);
        ((Set)this.configListenersMap.get(dataId)).add(etcdListener);
        etcdListener.onProcessEvent(new ConfigurationChangeEvent());
    }

    @Override
    public void removeConfigListener(String dataId, ConfigurationChangeListener listener) {
        Set<ConfigurationChangeListener> configChangeListeners = this.getConfigListeners(dataId);
        if (configChangeListeners == null || listener == null) {
            return;
        }
        for (ConfigurationChangeListener entry : configChangeListeners) {
            ConfigurationChangeListener target = ((EtcdListener)entry).getTargetListener();
            if (!listener.equals(target)) continue;
            entry.onShutDown();
            configChangeListeners.remove(entry);
            break;
        }
    }

    @Override
    public Set<ConfigurationChangeListener> getConfigListeners(String dataId) {
        return (Set)this.configListenersMap.get(dataId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Client getClient() {
        if (client != null) return client;
        Class<EtcdConfiguration> clazz = EtcdConfiguration.class;
        synchronized (EtcdConfiguration.class) {
            if (client != null) return client;
            client = Client.builder().endpoints(new String[]{FILE_CONFIG.getConfig("config.etcd3.serverAddr")}).build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    private <T> void complete(CompletableFuture<T> completableFuture, ConfigFuture configFuture) {
        block8: {
            try {
                T response = completableFuture.get();
                if (response instanceof GetResponse) {
                    ByteSequence value;
                    List keyValues = ((GetResponse)response).getKvs();
                    if (CollectionUtils.isNotEmpty(keyValues) && (value = ((KeyValue)keyValues.get(0)).getValue()) != null) {
                        configFuture.setResult(value.toString(CharsetUtil.UTF_8));
                    }
                    break block8;
                }
                if (response instanceof PutResponse) {
                    configFuture.setResult(Boolean.TRUE);
                    break block8;
                }
                if (response instanceof TxnResponse) {
                    boolean result = ((TxnResponse)response).isSucceeded();
                    if (result) {
                        configFuture.setResult(Boolean.TRUE);
                    }
                    break block8;
                }
                if (response instanceof DeleteResponse) {
                    configFuture.setResult(Boolean.TRUE);
                    break block8;
                }
                throw new ShouldNeverHappenException("unsupported response type");
            }
            catch (Exception e) {
                LOGGER.error("error occurred while completing the future{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    static {
        FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    }

    private static class EtcdListener
    implements ConfigurationChangeListener {
        private final String dataId;
        private final ConfigurationChangeListener listener;
        private Watch.Watcher watcher;
        private final ExecutorService executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("etcdListener", 1));

        public EtcdListener(String dataId, ConfigurationChangeListener listener) {
            this.dataId = dataId;
            this.listener = listener;
        }

        public ConfigurationChangeListener getTargetListener() {
            return this.listener;
        }

        @Override
        public void onShutDown() {
            this.watcher.close();
            this.getExecutorService().shutdownNow();
        }

        @Override
        public void onChangeEvent(final ConfigurationChangeEvent event) {
            Watch watchClient = EtcdConfiguration.getClient().getWatchClient();
            this.watcher = watchClient.watch(ByteSequence.from((String)this.dataId, (Charset)CharsetUtil.UTF_8), new Watch.Listener(){

                public void onNext(WatchResponse watchResponse) {
                    try {
                        GetResponse getResponse = (GetResponse)EtcdConfiguration.getClient().getKVClient().get(ByteSequence.from((String)dataId, (Charset)CharsetUtil.UTF_8)).get();
                        List keyValues = getResponse.getKvs();
                        if (CollectionUtils.isNotEmpty(keyValues)) {
                            event.setDataId(dataId).setNewValue(((KeyValue)keyValues.get(0)).getValue().toString(CharsetUtil.UTF_8));
                            listener.onChangeEvent(event);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("error occurred while getting value{}", (Object)e.getMessage(), (Object)e);
                    }
                }

                public void onError(Throwable throwable) {
                }

                public void onCompleted() {
                }
            });
        }

        @Override
        public ExecutorService getExecutorService() {
            return this.executor;
        }
    }
}

