/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.grpc.interceptor.server;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.seata.integration.grpc.interceptor.GrpcHeaderKey;
import io.seata.integration.grpc.interceptor.server.ServerListenerProxy;

public class ServerTransactionInterceptor
implements ServerInterceptor {
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        String xid = this.getRpcXid(metadata);
        return new ServerListenerProxy(xid, serverCallHandler.startCall(serverCall, metadata));
    }

    private String getRpcXid(Metadata metadata) {
        String rpcXid = (String)metadata.get(GrpcHeaderKey.HEADER_KEY);
        if (rpcXid == null) {
            rpcXid = (String)metadata.get(GrpcHeaderKey.HEADER_KEY_LOWERCASE);
        }
        return rpcXid;
    }
}

