/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.rm.datasource.undo.SQLUndoLog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ConnectionContext {
    private String xid;
    private Long branchId;
    private boolean isGlobalLockRequire;
    private Set<String> lockKeysBuffer = new HashSet<String>();
    private List<SQLUndoLog> sqlUndoItemsBuffer = new ArrayList<SQLUndoLog>();

    boolean isGlobalLockRequire() {
        return this.isGlobalLockRequire;
    }

    void setGlobalLockRequire(boolean isGlobalLockRequire) {
        this.isGlobalLockRequire = isGlobalLockRequire;
    }

    void appendLockKey(String lockKey) {
        this.lockKeysBuffer.add(lockKey);
    }

    void appendUndoItem(SQLUndoLog sqlUndoLog) {
        this.sqlUndoItemsBuffer.add(sqlUndoLog);
    }

    public boolean inGlobalTransaction() {
        return this.xid != null;
    }

    public boolean isBranchRegistered() {
        return this.branchId != null;
    }

    void bind(String xid) {
        if (xid == null) {
            throw new IllegalArgumentException("xid should not be null");
        }
        if (!this.inGlobalTransaction()) {
            this.setXid(xid);
        } else if (!this.xid.equals(xid)) {
            throw new ShouldNeverHappenException();
        }
    }

    public boolean hasUndoLog() {
        return !this.sqlUndoItemsBuffer.isEmpty();
    }

    public String getXid() {
        return this.xid;
    }

    void setXid(String xid) {
        this.xid = xid;
    }

    public Long getBranchId() {
        return this.branchId;
    }

    void setBranchId(Long branchId) {
        this.branchId = branchId;
    }

    public void reset() {
        this.reset(null);
    }

    void reset(String xid) {
        this.xid = xid;
        this.branchId = null;
        this.isGlobalLockRequire = false;
        this.lockKeysBuffer.clear();
        this.sqlUndoItemsBuffer.clear();
    }

    public String buildLockKeys() {
        if (this.lockKeysBuffer.isEmpty()) {
            return null;
        }
        StringBuilder appender = new StringBuilder();
        Iterator<String> iterable = this.lockKeysBuffer.iterator();
        while (iterable.hasNext()) {
            appender.append(iterable.next());
            if (!iterable.hasNext()) continue;
            appender.append(";");
        }
        return appender.toString();
    }

    public List<SQLUndoLog> getUndoItems() {
        return this.sqlUndoItemsBuffer;
    }

    public Set<String> getLockKeysBuffer() {
        return this.lockKeysBuffer;
    }

    public String toString() {
        return "ConnectionContext [xid=" + this.xid + ", branchId=" + this.branchId + ", lockKeysBuffer=" + this.lockKeysBuffer + ", sqlUndoItemsBuffer=" + this.sqlUndoItemsBuffer + "]";
    }
}

