/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec;

import io.seata.config.ConfigurationFactory;
import io.seata.rm.datasource.exec.LockWaitTimeoutException;

public class LockRetryController {
    private static int LOCK_RETRY_INTERNAL = ConfigurationFactory.getInstance().getInt("client.rm.lock.retryInterval", 10);
    private static int LOCK_RETRY_TIMES = ConfigurationFactory.getInstance().getInt("client.rm.lock.retryTimes", 30);
    private int lockRetryInternal = LOCK_RETRY_INTERNAL;
    private int lockRetryTimes = LOCK_RETRY_TIMES;

    public void sleep(Exception e) throws LockWaitTimeoutException {
        if (--this.lockRetryTimes < 0) {
            throw new LockWaitTimeoutException("Global lock wait timeout", e);
        }
        try {
            Thread.sleep(this.lockRetryInternal);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

