/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext.handlers;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.saga.engine.StateMachineConfig;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.pcext.InterceptableStateHandler;
import io.seata.saga.engine.pcext.StateHandler;
import io.seata.saga.engine.pcext.StateHandlerInterceptor;
import io.seata.saga.engine.pcext.StateInstruction;
import io.seata.saga.engine.pcext.utils.EngineUtils;
import io.seata.saga.proctrl.HierarchicalProcessContext;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.statelang.domain.impl.ScriptTaskStateImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptTaskStateHandler
implements StateHandler,
InterceptableStateHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptTaskStateHandler.class);
    private List<StateHandlerInterceptor> interceptors = new ArrayList<StateHandlerInterceptor>();
    private volatile Map<String, ScriptEngine> scriptEngineCache = new ConcurrentHashMap<String, ScriptEngine>();

    @Override
    public void process(ProcessContext context) throws EngineExecutionException {
        StateInstruction instruction = context.getInstruction(StateInstruction.class);
        ScriptTaskStateImpl state = (ScriptTaskStateImpl)instruction.getState(context);
        String scriptType = state.getScriptType();
        String scriptContent = state.getScriptContent();
        try {
            Map inputExpMap;
            List<Object> inputExps;
            StateMachineConfig stateMachineConfig;
            ScriptEngine scriptEngine;
            List input = (List)context.getVariable("inputParams");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(">>>>>>>>>>>>>>>>>>>>>> Start to execute ScriptTaskState[{}], ScriptType[{}], Input:{}", new Object[]{state.getName(), scriptType, input});
            }
            if ((scriptEngine = this.getScriptEngineFromCache(scriptType, (stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_")).getScriptEngineManager())) == null) {
                throw new EngineExecutionException("No such ScriptType[" + scriptType + "]", FrameworkErrorCode.ObjectNotExists);
            }
            SimpleBindings bindings = null;
            Map inputMap = null;
            if (input != null && input.size() > 0 && input.get(0) instanceof Map) {
                inputMap = (Map)input.get(0);
            }
            if ((inputExps = state.getInput()) != null && inputExps.size() > 0 && inputExps.get(0) instanceof Map && (inputExpMap = (Map)inputExps.get(0)).size() > 0) {
                bindings = new SimpleBindings();
                for (String property : inputExpMap.keySet()) {
                    if (inputMap != null && inputMap.containsKey(property)) {
                        bindings.put(property, inputMap.get(property));
                        continue;
                    }
                    bindings.put(property, (Object)null);
                }
            }
            Object result = bindings != null ? scriptEngine.eval(scriptContent, bindings) : scriptEngine.eval(scriptContent);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("<<<<<<<<<<<<<<<<<<<<<< ScriptTaskState[{}], ScriptType[{}], Execute finish. result: {}", new Object[]{state.getName(), scriptType, result});
            }
            if (result != null) {
                ((HierarchicalProcessContext)context).setVariableLocally("outputParams", result);
            }
        }
        catch (Throwable e) {
            LOGGER.error("<<<<<<<<<<<<<<<<<<<<<< ScriptTaskState[{}], ScriptTaskState[{}] Execute failed.", new Object[]{state.getName(), scriptType, e});
            ((HierarchicalProcessContext)context).setVariableLocally("currentException", e);
            EngineUtils.handleException(context, state, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScriptEngine getScriptEngineFromCache(String scriptType, ScriptEngineManager scriptEngineManager) {
        ScriptEngine scriptEngine = this.scriptEngineCache.get(scriptType);
        if (scriptEngine == null) {
            Map<String, ScriptEngine> map = this.scriptEngineCache;
            synchronized (map) {
                scriptEngine = this.scriptEngineCache.get(scriptType);
                if (scriptEngine == null && (scriptEngine = scriptEngineManager.getEngineByName(scriptType)) != null) {
                    this.scriptEngineCache.put(scriptType, scriptEngine);
                }
            }
        }
        return scriptEngine;
    }

    @Override
    public List<StateHandlerInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public void addInterceptor(StateHandlerInterceptor interceptor) {
        if (this.interceptors != null && !this.interceptors.contains(interceptor)) {
            this.interceptors.add(interceptor);
        }
    }

    public void setInterceptors(List<StateHandlerInterceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

