/*
 * Copyright 2016-2018 shardingsphere.io.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * </p>
 */

package io.shardingsphere.core.routing;

import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.routing.router.sharding.GeneratedKey;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/**
 * SQL route result.
 * 
 * @author gaohongtao
 * @author zhangliang
 * @author zhaojun
 */
@RequiredArgsConstructor
@Getter
public final class SQLRouteResult {
    
    private final SQLStatement sqlStatement;
    
    private final GeneratedKey generatedKey;
    
    private final Set<SQLExecutionUnit> executionUnits = new LinkedHashSet<>();
    
    public SQLRouteResult(final SQLStatement sqlStatement) {
        this(sqlStatement, null);
    }
    
    /**
     * Get SQL units grouped by data source name.
     * 
     * @return SQL units grouped by data source name.
     */
    public Map<String, Collection<SQLUnit>> getSQLUnitGroups() {
        Map<String, Collection<SQLUnit>> result = new LinkedHashMap<>(executionUnits.size(), 1);
        for (SQLExecutionUnit each : executionUnits) {
            if (!result.containsKey(each.getDataSource())) {
                result.put(each.getDataSource(), new LinkedList<SQLUnit>());
            }
            result.get(each.getDataSource()).add(each.getSqlUnit());
        }
        return result;
    }
}
