/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.constant;

import io.shardingsphere.core.constant.ConnectionMode;
import io.shardingsphere.core.constant.TransactionType;

public enum ShardingPropertiesConstant {
    SQL_SHOW("sql.show", Boolean.FALSE.toString(), Boolean.TYPE),
    ACCEPTOR_SIZE("acceptor.size", String.valueOf(Runtime.getRuntime().availableProcessors() * 2), Integer.TYPE),
    EXECUTOR_SIZE("executor.size", String.valueOf(0), Integer.TYPE),
    CONNECTION_MODE("connection.mode", ConnectionMode.MEMORY_STRICTLY.name(), String.class),
    PROXY_TRANSACTION_MODE("proxy.transaction.mode", TransactionType.NONE.name(), String.class),
    PROXY_BACKEND_USE_NIO("proxy.backend.use.nio", Boolean.FALSE.toString(), Boolean.TYPE),
    PROXY_BACKEND_MAX_CONNECTIONS("proxy.backend.max.connections", "8", Integer.TYPE),
    PROXY_BACKEND_CONNECTION_TIMEOUT_SECONDS("proxy.backend.connection.timeout.seconds", "60", Integer.TYPE);

    private final String key;
    private final String defaultValue;
    private final Class<?> type;

    public static ShardingPropertiesConstant findByKey(String key) {
        for (ShardingPropertiesConstant each : ShardingPropertiesConstant.values()) {
            if (!each.getKey().equals(key)) continue;
            return each;
        }
        return null;
    }

    private ShardingPropertiesConstant(String key, String defaultValue, Class<?> type) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Class<?> getType() {
        return this.type;
    }
}

