/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.merger.dql.groupby;

import com.google.common.base.Preconditions;
import io.shardingsphere.core.merger.dql.common.MemoryQueryResultRow;
import io.shardingsphere.core.merger.dql.orderby.CompareUtil;
import io.shardingsphere.core.parsing.parser.context.OrderItem;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.List;

public final class GroupByRowComparator
implements Comparator<MemoryQueryResultRow> {
    private final SelectStatement selectStatement;

    @Override
    public int compare(MemoryQueryResultRow o1, MemoryQueryResultRow o2) {
        if (!this.selectStatement.getOrderByItems().isEmpty()) {
            return this.compare(o1, o2, this.selectStatement.getOrderByItems());
        }
        return this.compare(o1, o2, this.selectStatement.getGroupByItems());
    }

    private int compare(MemoryQueryResultRow o1, MemoryQueryResultRow o2, List<OrderItem> orderItems) {
        for (OrderItem each : orderItems) {
            Object orderValue1 = o1.getCell(each.getIndex());
            Preconditions.checkState((null == orderValue1 || orderValue1 instanceof Comparable ? 1 : 0) != 0, (Object)"Order by value must implements Comparable");
            Object orderValue2 = o2.getCell(each.getIndex());
            Preconditions.checkState((null == orderValue2 || orderValue2 instanceof Comparable ? 1 : 0) != 0, (Object)"Order by value must implements Comparable");
            int result = CompareUtil.compareTo((Comparable)orderValue1, (Comparable)orderValue2, each.getOrderDirection(), each.getNullOrderDirection());
            if (0 == result) continue;
            return result;
        }
        return 0;
    }

    @ConstructorProperties(value={"selectStatement"})
    public GroupByRowComparator(SelectStatement selectStatement) {
        this.selectStatement = selectStatement;
    }
}

