/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.metadata.datasource.dialect;

import com.google.common.base.Strings;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.metadata.datasource.DataSourceMetaData;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SQLServerDataSourceMetaData
implements DataSourceMetaData {
    private static final int DEFAULT_PORT = 1433;
    private final String hostName;
    private final int port;
    private final String schemeName;
    private final Pattern pattern = Pattern.compile("jdbc:(microsoft:)?sqlserver://([a-zA-Z0-9\\-\\.]+):?([0-9]*);DatabaseName=(\\w+)");

    public SQLServerDataSourceMetaData(String url) {
        Matcher matcher = this.pattern.matcher(url);
        if (!matcher.find()) {
            throw new ShardingException("The URL of JDBC is not supported.", new Object[0]);
        }
        this.hostName = matcher.group(2);
        this.port = Strings.isNullOrEmpty((String)matcher.group(3)) ? 1433 : Integer.valueOf(matcher.group(3));
        this.schemeName = matcher.group(4);
    }

    @Override
    public boolean isInSameDatabaseInstance(DataSourceMetaData dataSourceMetaData) {
        return this.hostName.equals(dataSourceMetaData.getHostName()) && this.port == dataSourceMetaData.getPort();
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getSchemeName() {
        return this.schemeName;
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

