/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.metadata.table.executor;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.metadata.table.ColumnMetaData;
import io.shardingsphere.core.metadata.table.TableMetaData;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataConnectionManager;
import io.shardingsphere.core.rule.DataNode;
import io.shardingsphere.core.rule.ShardingDataSourceNames;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.rule.TableRule;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public final class TableMetaDataLoader {
    private final ListeningExecutorService executorService;
    private final TableMetaDataConnectionManager connectionManager;

    public TableMetaData load(String logicTableName, ShardingRule shardingRule) {
        return this.load(shardingRule.getTableRuleByLogicTableName(logicTableName), shardingRule.getShardingDataSourceNames());
    }

    private TableMetaData load(TableRule tableRule, ShardingDataSourceNames shardingDataSourceNames) {
        List<TableMetaData> actualTableMetaDataList = this.loadActualTableMetaDataList(tableRule.getActualDataNodes(), shardingDataSourceNames);
        this.checkUniformed(tableRule.getLogicTable(), actualTableMetaDataList);
        return actualTableMetaDataList.iterator().next();
    }

    private TableMetaData load(DataNode dataNode) throws SQLException {
        if (this.connectionManager.isAutoClose()) {
            try (Connection connection = this.connectionManager.getConnection(dataNode.getDataSourceName());){
                TableMetaData tableMetaData = this.load(connection, dataNode);
                return tableMetaData;
            }
        }
        return this.load(this.connectionManager.getConnection(dataNode.getDataSourceName()), dataNode);
    }

    private TableMetaData load(Connection connection, DataNode dataNode) throws SQLException {
        return new TableMetaData(this.isTableExist(connection, dataNode.getTableName()) ? this.getColumnMetaDataList(connection, dataNode.getTableName()) : Collections.emptyList());
    }

    private boolean isTableExist(Connection connection, String actualTableName) throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTables(null, null, actualTableName, null);){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    private List<ColumnMetaData> getColumnMetaDataList(Connection connection, String actualTableName) throws SQLException {
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        Collection<String> primaryKeys = this.getPrimaryKeys(connection, actualTableName);
        try (ResultSet resultSet = connection.getMetaData().getColumns(null, null, actualTableName, null);){
            while (resultSet.next()) {
                String columnName = resultSet.getString("COLUMN_NAME");
                String columnType = resultSet.getString("TYPE_NAME");
                result.add(new ColumnMetaData(columnName, columnType, primaryKeys.contains(columnName)));
            }
        }
        return result;
    }

    private Collection<String> getPrimaryKeys(Connection connection, String actualTableName) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(null, null, actualTableName);){
            while (resultSet.next()) {
                result.add(resultSet.getString("COLUMN_NAME"));
            }
        }
        return result;
    }

    private List<TableMetaData> loadActualTableMetaDataList(List<DataNode> actualDataNodes, final ShardingDataSourceNames shardingDataSourceNames) {
        LinkedList<ListenableFuture> result = new LinkedList<ListenableFuture>();
        for (final DataNode each : actualDataNodes) {
            result.add(this.executorService.submit((Callable)new Callable<TableMetaData>(){

                @Override
                public TableMetaData call() throws SQLException {
                    return TableMetaDataLoader.this.load(new DataNode(shardingDataSourceNames.getRawMasterDataSourceName(each.getDataSourceName()), each.getTableName()));
                }
            }));
        }
        try {
            return (List)Futures.allAsList(result).get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new ShardingException(ex);
        }
    }

    private void checkUniformed(String logicTableName, List<TableMetaData> actualTableMetaDataList) {
        TableMetaData sample = actualTableMetaDataList.iterator().next();
        for (TableMetaData each : actualTableMetaDataList) {
            if (sample.equals(each)) continue;
            throw new ShardingException("Cannot get uniformed table structure for `%s`. The different meta data of actual tables are as follows:\n%s\n%s.", logicTableName, sample, each);
        }
    }

    @ConstructorProperties(value={"executorService", "connectionManager"})
    public TableMetaDataLoader(ListeningExecutorService executorService, TableMetaDataConnectionManager connectionManager) {
        this.executorService = executorService;
        this.connectionManager = connectionManager;
    }
}

