/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.clause;

import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.clause.SQLClauseParser;
import io.shardingsphere.core.parsing.parser.clause.expression.BasicExpressionParser;
import io.shardingsphere.core.parsing.parser.context.condition.Column;
import io.shardingsphere.core.parsing.parser.dialect.ExpressionParserFactory;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingException;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.util.SQLUtil;

public class InsertDuplicateKeyUpdateClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final BasicExpressionParser basicExpressionParser;

    public InsertDuplicateKeyUpdateClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public void parse(InsertStatement insertStatement) {
        if (!this.lexerEngine.skipIfEqual(this.getCustomizedInsertKeywords())) {
            return;
        }
        this.lexerEngine.accept(DefaultKeyword.DUPLICATE);
        this.lexerEngine.accept(DefaultKeyword.KEY);
        this.lexerEngine.accept(DefaultKeyword.UPDATE);
        do {
            Column column;
            if (this.shardingRule.isShardingColumn(column = new Column(SQLUtil.getExactlyValue(this.lexerEngine.getCurrentToken().getLiterals()), insertStatement.getTables().getSingleTableName()))) {
                throw new SQLParsingException("INSERT INTO .... ON DUPLICATE KEY UPDATE can not support on sharding column, token is '%s', literals is '%s'.", this.lexerEngine.getCurrentToken().getType(), this.lexerEngine.getCurrentToken().getLiterals());
            }
            this.basicExpressionParser.parse(insertStatement);
            this.lexerEngine.accept(Symbol.EQ);
            if (this.lexerEngine.skipIfEqual(DefaultKeyword.VALUES)) {
                this.lexerEngine.accept(Symbol.LEFT_PAREN);
                this.basicExpressionParser.parse(insertStatement);
                this.lexerEngine.accept(Symbol.RIGHT_PAREN);
                continue;
            }
            this.lexerEngine.nextToken();
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
    }

    protected Keyword[] getCustomizedInsertKeywords() {
        return new Keyword[0];
    }
}

