/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.clause;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.clause.SQLClauseParser;
import io.shardingsphere.core.parsing.parser.clause.condition.NullCondition;
import io.shardingsphere.core.parsing.parser.clause.expression.AliasExpressionParser;
import io.shardingsphere.core.parsing.parser.clause.expression.BasicExpressionParser;
import io.shardingsphere.core.parsing.parser.context.condition.AndCondition;
import io.shardingsphere.core.parsing.parser.context.condition.Column;
import io.shardingsphere.core.parsing.parser.context.condition.Condition;
import io.shardingsphere.core.parsing.parser.context.condition.OrCondition;
import io.shardingsphere.core.parsing.parser.context.limit.Limit;
import io.shardingsphere.core.parsing.parser.context.limit.LimitValue;
import io.shardingsphere.core.parsing.parser.context.selectitem.SelectItem;
import io.shardingsphere.core.parsing.parser.context.table.Table;
import io.shardingsphere.core.parsing.parser.context.table.Tables;
import io.shardingsphere.core.parsing.parser.dialect.ExpressionParserFactory;
import io.shardingsphere.core.parsing.parser.expression.SQLExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLIdentifierExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLNumberExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLPlaceholderExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLPropertyExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLTextExpression;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.parsing.parser.token.OffsetToken;
import io.shardingsphere.core.parsing.parser.token.RowCountToken;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.util.SQLUtil;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class WhereClauseParser
implements SQLClauseParser {
    private final DatabaseType databaseType;
    private final LexerEngine lexerEngine;
    private final AliasExpressionParser aliasExpressionParser;
    private final BasicExpressionParser basicExpressionParser;

    public WhereClauseParser(DatabaseType databaseType, LexerEngine lexerEngine) {
        this.databaseType = databaseType;
        this.lexerEngine = lexerEngine;
        this.aliasExpressionParser = ExpressionParserFactory.createAliasExpressionParser(lexerEngine);
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public void parse(ShardingRule shardingRule, SQLStatement sqlStatement, List<SelectItem> items) {
        this.aliasExpressionParser.parseTableAlias();
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.WHERE)) {
            this.parseWhere(shardingRule, sqlStatement, items);
        }
    }

    private void parseWhere(ShardingRule shardingRule, SQLStatement sqlStatement, List<SelectItem> items) {
        OrCondition orCondition = this.parseOr(shardingRule, sqlStatement, items).optimize();
        if (1 != orCondition.getAndConditions().size() || !(orCondition.getAndConditions().get(0).getConditions().get(0) instanceof NullCondition)) {
            sqlStatement.getConditions().getOrCondition().getAndConditions().addAll(orCondition.getAndConditions());
        }
    }

    private OrCondition parseOr(ShardingRule shardingRule, SQLStatement sqlStatement, List<SelectItem> items) {
        OrCondition result = new OrCondition();
        do {
            if (this.lexerEngine.skipIfEqual(Symbol.LEFT_PAREN)) {
                OrCondition subOrCondition = this.parseOr(shardingRule, sqlStatement, items);
                this.lexerEngine.skipIfEqual(Symbol.RIGHT_PAREN);
                OrCondition orCondition = null;
                if (this.lexerEngine.skipIfEqual(DefaultKeyword.AND)) {
                    orCondition = this.parseAnd(shardingRule, sqlStatement, items);
                }
                result.getAndConditions().addAll(this.merge(subOrCondition, orCondition).getAndConditions());
                continue;
            }
            OrCondition orCondition = this.parseAnd(shardingRule, sqlStatement, items);
            result.getAndConditions().addAll(orCondition.getAndConditions());
        } while (this.lexerEngine.skipIfEqual(DefaultKeyword.OR));
        return result;
    }

    private OrCondition parseAnd(ShardingRule shardingRule, SQLStatement sqlStatement, List<SelectItem> items) {
        OrCondition result = new OrCondition();
        do {
            if (this.lexerEngine.skipIfEqual(Symbol.LEFT_PAREN)) {
                OrCondition subOrCondition = this.parseOr(shardingRule, sqlStatement, items);
                this.lexerEngine.skipIfEqual(Symbol.RIGHT_PAREN);
                result = this.merge(result, subOrCondition);
                continue;
            }
            Condition condition = this.parseComparisonCondition(shardingRule, sqlStatement, items);
            this.skipsDoubleColon();
            result = this.merge(result, new OrCondition(condition));
        } while (this.lexerEngine.skipIfEqual(DefaultKeyword.AND));
        return result;
    }

    private OrCondition merge(OrCondition orCondition1, OrCondition orCondition2) {
        if (null == orCondition1 || orCondition1.getAndConditions().isEmpty()) {
            return orCondition2;
        }
        if (null == orCondition2 || orCondition2.getAndConditions().isEmpty()) {
            return orCondition1;
        }
        OrCondition result = new OrCondition();
        for (AndCondition each1 : orCondition1.getAndConditions()) {
            for (AndCondition each2 : orCondition2.getAndConditions()) {
                result.getAndConditions().add(this.merge(each1, each2));
            }
        }
        return result;
    }

    private AndCondition merge(AndCondition andCondition1, AndCondition andCondition2) {
        AndCondition result = new AndCondition();
        for (Condition each : andCondition1.getConditions()) {
            result.getConditions().add(each);
        }
        for (Condition each : andCondition2.getConditions()) {
            result.getConditions().add(each);
        }
        return result.optimize();
    }

    private Condition parseComparisonCondition(ShardingRule shardingRule, SQLStatement sqlStatement, List<SelectItem> items) {
        SQLExpression left = this.basicExpressionParser.parse(sqlStatement);
        if (this.lexerEngine.skipIfEqual(Symbol.EQ)) {
            Condition result = this.parseEqualCondition(shardingRule, sqlStatement, left);
            return result;
        }
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.IN)) {
            Condition result = this.parseInCondition(shardingRule, sqlStatement, left);
            return result;
        }
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.BETWEEN)) {
            Condition result = this.parseBetweenCondition(shardingRule, sqlStatement, left);
            return result;
        }
        NullCondition result = new NullCondition();
        if (sqlStatement instanceof SelectStatement && this.isRowNumberCondition(items, left)) {
            if (this.lexerEngine.skipIfEqual(Symbol.LT)) {
                this.parseRowCountCondition((SelectStatement)sqlStatement, false);
                return result;
            }
            if (this.lexerEngine.skipIfEqual(Symbol.LT_EQ)) {
                this.parseRowCountCondition((SelectStatement)sqlStatement, true);
                return result;
            }
            if (this.lexerEngine.skipIfEqual(Symbol.GT)) {
                this.parseOffsetCondition((SelectStatement)sqlStatement, false);
                return result;
            }
            if (this.lexerEngine.skipIfEqual(Symbol.GT_EQ)) {
                this.parseOffsetCondition((SelectStatement)sqlStatement, true);
                return result;
            }
        }
        LinkedList<Keyword> otherConditionOperators = new LinkedList<Keyword>(Arrays.asList(this.getCustomizedOtherConditionOperators()));
        otherConditionOperators.addAll(Arrays.asList(Symbol.LT, Symbol.LT_EQ, Symbol.GT, Symbol.GT_EQ, Symbol.LT_GT, Symbol.BANG_EQ, Symbol.BANG_GT, Symbol.BANG_LT, DefaultKeyword.LIKE, DefaultKeyword.IS));
        if (this.lexerEngine.skipIfEqual(otherConditionOperators.toArray(new Keyword[otherConditionOperators.size()]))) {
            this.lexerEngine.skipIfEqual(DefaultKeyword.NOT);
            this.parseOtherCondition(sqlStatement);
        }
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.NOT)) {
            this.parseNotCondition(sqlStatement);
        }
        return result;
    }

    private Condition parseEqualCondition(ShardingRule shardingRule, SQLStatement sqlStatement, SQLExpression left) {
        Optional<Column> column;
        SQLExpression right = this.basicExpressionParser.parse(sqlStatement);
        if ((sqlStatement.getTables().isSingleTable() || left instanceof SQLPropertyExpression) && (right instanceof SQLNumberExpression || right instanceof SQLTextExpression || right instanceof SQLPlaceholderExpression) && (column = this.find(sqlStatement.getTables(), left)).isPresent() && shardingRule.isShardingColumn((Column)column.get())) {
            return new Condition((Column)column.get(), right);
        }
        return new NullCondition();
    }

    private Condition parseInCondition(ShardingRule shardingRule, SQLStatement sqlStatement, SQLExpression left) {
        this.lexerEngine.accept(Symbol.LEFT_PAREN);
        LinkedList<SQLExpression> rights = new LinkedList<SQLExpression>();
        do {
            rights.add(this.basicExpressionParser.parse(sqlStatement));
            this.skipsDoubleColon();
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
        this.lexerEngine.accept(Symbol.RIGHT_PAREN);
        Optional<Column> column = this.find(sqlStatement.getTables(), left);
        if (column.isPresent() && shardingRule.isShardingColumn((Column)column.get())) {
            return new Condition((Column)column.get(), rights);
        }
        return new NullCondition();
    }

    private Condition parseBetweenCondition(ShardingRule shardingRule, SQLStatement sqlStatement, SQLExpression left) {
        LinkedList<SQLExpression> rights = new LinkedList<SQLExpression>();
        rights.add(this.basicExpressionParser.parse(sqlStatement));
        this.skipsDoubleColon();
        this.lexerEngine.accept(DefaultKeyword.AND);
        rights.add(this.basicExpressionParser.parse(sqlStatement));
        Optional<Column> column = this.find(sqlStatement.getTables(), left);
        if (column.isPresent() && shardingRule.isShardingColumn((Column)column.get())) {
            return new Condition((Column)column.get(), (SQLExpression)rights.get(0), (SQLExpression)rights.get(1));
        }
        return new NullCondition();
    }

    private boolean isRowNumberCondition(List<SelectItem> items, SQLExpression sqlExpression) {
        String columnLabel = null;
        if (sqlExpression instanceof SQLIdentifierExpression) {
            columnLabel = ((SQLIdentifierExpression)sqlExpression).getName();
        } else if (sqlExpression instanceof SQLPropertyExpression) {
            columnLabel = ((SQLPropertyExpression)sqlExpression).getName();
        }
        return null != columnLabel && this.isRowNumberCondition(items, columnLabel);
    }

    protected boolean isRowNumberCondition(List<SelectItem> items, String columnLabel) {
        return false;
    }

    private void parseRowCountCondition(SelectStatement selectStatement, boolean includeRowCount) {
        SQLExpression sqlExpression = this.basicExpressionParser.parse(selectStatement);
        if (null == selectStatement.getLimit()) {
            selectStatement.setLimit(new Limit(this.databaseType));
        }
        if (sqlExpression instanceof SQLNumberExpression) {
            int rowCount = ((SQLNumberExpression)sqlExpression).getNumber().intValue();
            selectStatement.getLimit().setRowCount(new LimitValue(rowCount, -1, includeRowCount));
            selectStatement.getSqlTokens().add(new RowCountToken(this.lexerEngine.getCurrentToken().getEndPosition() - String.valueOf(rowCount).length() - this.lexerEngine.getCurrentToken().getLiterals().length(), rowCount));
        } else if (sqlExpression instanceof SQLPlaceholderExpression) {
            selectStatement.getLimit().setRowCount(new LimitValue(-1, ((SQLPlaceholderExpression)sqlExpression).getIndex(), includeRowCount));
        }
    }

    private void parseOffsetCondition(SelectStatement selectStatement, boolean includeOffset) {
        SQLExpression sqlExpression = this.basicExpressionParser.parse(selectStatement);
        if (null == selectStatement.getLimit()) {
            selectStatement.setLimit(new Limit(this.databaseType));
        }
        if (sqlExpression instanceof SQLNumberExpression) {
            int offset = ((SQLNumberExpression)sqlExpression).getNumber().intValue();
            selectStatement.getLimit().setOffset(new LimitValue(offset, -1, includeOffset));
            selectStatement.getSqlTokens().add(new OffsetToken(this.lexerEngine.getCurrentToken().getEndPosition() - String.valueOf(offset).length() - this.lexerEngine.getCurrentToken().getLiterals().length(), offset));
        } else if (sqlExpression instanceof SQLPlaceholderExpression) {
            selectStatement.getLimit().setOffset(new LimitValue(-1, ((SQLPlaceholderExpression)sqlExpression).getIndex(), includeOffset));
        }
    }

    protected Keyword[] getCustomizedOtherConditionOperators() {
        return new Keyword[0];
    }

    private void parseOtherCondition(SQLStatement sqlStatement) {
        this.basicExpressionParser.parse(sqlStatement);
    }

    private void parseNotCondition(SQLStatement sqlStatement) {
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.BETWEEN)) {
            this.parseOtherCondition(sqlStatement);
            this.skipsDoubleColon();
            this.lexerEngine.accept(DefaultKeyword.AND);
            this.parseOtherCondition(sqlStatement);
            return;
        }
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.IN)) {
            this.lexerEngine.accept(Symbol.LEFT_PAREN);
            do {
                this.parseOtherCondition(sqlStatement);
                this.skipsDoubleColon();
            } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
            this.lexerEngine.accept(Symbol.RIGHT_PAREN);
        } else {
            this.lexerEngine.nextToken();
            this.parseOtherCondition(sqlStatement);
        }
    }

    private Optional<Column> find(Tables tables, SQLExpression sqlExpression) {
        if (sqlExpression instanceof SQLPropertyExpression) {
            return this.getColumnWithOwner(tables, (SQLPropertyExpression)sqlExpression);
        }
        if (sqlExpression instanceof SQLIdentifierExpression) {
            return this.getColumnWithoutOwner(tables, (SQLIdentifierExpression)sqlExpression);
        }
        return Optional.absent();
    }

    private Optional<Column> getColumnWithOwner(Tables tables, SQLPropertyExpression propertyExpression) {
        Optional<Table> table = tables.find(SQLUtil.getExactlyValue(propertyExpression.getOwner().getName()));
        return table.isPresent() ? Optional.of((Object)new Column(SQLUtil.getExactlyValue(propertyExpression.getName()), ((Table)table.get()).getName())) : Optional.absent();
    }

    private Optional<Column> getColumnWithoutOwner(Tables tables, SQLIdentifierExpression identifierExpression) {
        return tables.isSingleTable() ? Optional.of((Object)new Column(SQLUtil.getExactlyValue(identifierExpression.getName()), tables.getSingleTableName())) : Optional.absent();
    }

    private void skipsDoubleColon() {
        if (this.lexerEngine.skipIfEqual(Symbol.DOUBLE_COLON)) {
            this.lexerEngine.nextToken();
        }
    }
}

