/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.clause.expression;

import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Literals;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.lexer.token.TokenType;
import io.shardingsphere.core.util.SQLUtil;
import java.beans.ConstructorProperties;

public class AliasExpressionParser {
    private final LexerEngine lexerEngine;

    public Optional<String> parseSelectItemAlias() {
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.AS)) {
            return this.parseWithAs();
        }
        if (this.lexerEngine.equalAny(this.getDefaultAvailableKeywordsForSelectItemAlias()) || this.lexerEngine.equalAny(this.getCustomizedAvailableKeywordsForSelectItemAlias())) {
            return this.parseAlias();
        }
        return Optional.absent();
    }

    private Optional<String> parseWithAs() {
        if (this.lexerEngine.equalAny(Symbol.values())) {
            return Optional.absent();
        }
        return this.parseAlias();
    }

    private Optional<String> parseAlias() {
        String result = SQLUtil.getExactlyValue(this.lexerEngine.getCurrentToken().getLiterals());
        this.lexerEngine.nextToken();
        return Optional.of((Object)result);
    }

    private TokenType[] getDefaultAvailableKeywordsForSelectItemAlias() {
        return new TokenType[]{Literals.IDENTIFIER, Literals.CHARS, DefaultKeyword.BITMAP, DefaultKeyword.NOSORT, DefaultKeyword.REVERSE, DefaultKeyword.COMPILE, DefaultKeyword.NEW, DefaultKeyword.ADVISE, DefaultKeyword.AVG, DefaultKeyword.MAX, DefaultKeyword.MIN, DefaultKeyword.SUM, DefaultKeyword.COUNT, DefaultKeyword.ROUND, DefaultKeyword.TRUNC, DefaultKeyword.LENGTH, DefaultKeyword.CHAR_LENGTH, DefaultKeyword.SUBSTR, DefaultKeyword.INSTR, DefaultKeyword.INITCAP, DefaultKeyword.UPPER, DefaultKeyword.LOWER, DefaultKeyword.LTRIM, DefaultKeyword.RTRIM, DefaultKeyword.TRANSLATE, DefaultKeyword.LPAD, DefaultKeyword.RPAD, DefaultKeyword.DECODE, DefaultKeyword.NVL};
    }

    protected TokenType[] getCustomizedAvailableKeywordsForSelectItemAlias() {
        return new TokenType[0];
    }

    public Optional<String> parseTableAlias() {
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.AS)) {
            return this.parseWithAs();
        }
        if (this.lexerEngine.equalAny(this.getDefaultAvailableKeywordsForTableAlias()) || this.lexerEngine.equalAny(this.getCustomizedAvailableKeywordsForTableAlias())) {
            return this.parseAlias();
        }
        return Optional.absent();
    }

    private TokenType[] getDefaultAvailableKeywordsForTableAlias() {
        return new TokenType[]{Literals.IDENTIFIER, Literals.CHARS, DefaultKeyword.SEQUENCE, DefaultKeyword.NO, DefaultKeyword.AFTER, DefaultKeyword.BITMAP, DefaultKeyword.NOSORT, DefaultKeyword.REVERSE, DefaultKeyword.COMPILE, DefaultKeyword.ENABLE, DefaultKeyword.DISABLE, DefaultKeyword.NEW, DefaultKeyword.UNTIL, DefaultKeyword.ADVISE, DefaultKeyword.PASSWORD, DefaultKeyword.LOCAL, DefaultKeyword.GLOBAL, DefaultKeyword.STORAGE, DefaultKeyword.DATA, DefaultKeyword.TIME, DefaultKeyword.BOOLEAN, DefaultKeyword.GREATEST, DefaultKeyword.LEAST, DefaultKeyword.ROUND, DefaultKeyword.TRUNC, DefaultKeyword.POSITION, DefaultKeyword.LENGTH, DefaultKeyword.CHAR_LENGTH, DefaultKeyword.SUBSTRING, DefaultKeyword.SUBSTR, DefaultKeyword.INSTR, DefaultKeyword.INITCAP, DefaultKeyword.UPPER, DefaultKeyword.LOWER, DefaultKeyword.TRIM};
    }

    protected TokenType[] getCustomizedAvailableKeywordsForTableAlias() {
        return new TokenType[0];
    }

    @ConstructorProperties(value={"lexerEngine"})
    public AliasExpressionParser(LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
    }
}

