/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.dialect.mysql.sql;

import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.dialect.mysql.MySQLKeyword;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.parser.clause.TableReferencesClauseParser;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowColumnsStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowCreateTableStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowDatabasesStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowIndexStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowOtherStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowTablesStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.DALStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.show.AbstractShowParser;
import io.shardingsphere.core.parsing.parser.token.RemoveToken;
import io.shardingsphere.core.parsing.parser.token.SchemaToken;
import io.shardingsphere.core.rule.ShardingRule;
import java.beans.ConstructorProperties;

public final class MySQLShowParser
extends AbstractShowParser {
    private final LexerEngine lexerEngine;
    private final TableReferencesClauseParser tableReferencesClauseParser;

    public MySQLShowParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = new TableReferencesClauseParser(shardingRule, lexerEngine);
    }

    @Override
    public DALStatement parse() {
        this.lexerEngine.nextToken();
        this.lexerEngine.skipIfEqual(DefaultKeyword.FULL);
        if (this.lexerEngine.equalAny(MySQLKeyword.DATABASES)) {
            return new ShowDatabasesStatement();
        }
        if (this.lexerEngine.skipIfEqual(MySQLKeyword.TABLES)) {
            ShowTablesStatement result = new ShowTablesStatement();
            if (this.lexerEngine.equalAny(DefaultKeyword.FROM, DefaultKeyword.IN)) {
                int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
                this.lexerEngine.nextToken();
                this.lexerEngine.nextToken();
                result.getSqlTokens().add(new RemoveToken(beginPosition, this.lexerEngine.getCurrentToken().getEndPosition()));
            }
            return result;
        }
        if (this.lexerEngine.skipIfEqual(MySQLKeyword.COLUMNS, MySQLKeyword.FIELDS)) {
            ShowColumnsStatement result = new ShowColumnsStatement();
            this.lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN);
            this.tableReferencesClauseParser.parseSingleTableWithoutAlias(result);
            if (this.lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN)) {
                int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
                result.getSqlTokens().add(new SchemaToken(beginPosition, this.lexerEngine.getCurrentToken().getLiterals(), result.getTables().getSingleTableName()));
            }
            return result;
        }
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.CREATE) && this.lexerEngine.skipIfEqual(DefaultKeyword.TABLE)) {
            ShowCreateTableStatement result = new ShowCreateTableStatement();
            this.tableReferencesClauseParser.parseSingleTableWithoutAlias(result);
            return result;
        }
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.INDEX, MySQLKeyword.INDEXES, MySQLKeyword.KEYS)) {
            ShowIndexStatement result = new ShowIndexStatement();
            this.lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN);
            this.tableReferencesClauseParser.parseSingleTableWithoutAlias(result);
            if (this.lexerEngine.skipIfEqual(DefaultKeyword.FROM, DefaultKeyword.IN)) {
                int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
                result.getSqlTokens().add(new SchemaToken(beginPosition, this.lexerEngine.getCurrentToken().getLiterals(), result.getTables().getSingleTableName()));
            }
            return result;
        }
        return new ShowOtherStatement();
    }

    @ConstructorProperties(value={"lexerEngine", "tableReferencesClauseParser"})
    public MySQLShowParser(LexerEngine lexerEngine, TableReferencesClauseParser tableReferencesClauseParser) {
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = tableReferencesClauseParser;
    }
}

