/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.dialect.oracle.clause;

import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.dialect.oracle.OracleKeyword;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.clause.TableReferencesClauseParser;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.rule.ShardingRule;

public final class OracleTableReferencesClauseParser
extends TableReferencesClauseParser {
    public OracleTableReferencesClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        super(shardingRule, lexerEngine);
    }

    @Override
    protected void parseTableReference(SQLStatement sqlStatement, boolean isSingleTableOnly) {
        if (this.getLexerEngine().skipIfEqual(OracleKeyword.ONLY)) {
            this.getLexerEngine().skipIfEqual(Symbol.LEFT_PAREN);
            this.parseQueryTableExpression(sqlStatement, isSingleTableOnly);
            this.getLexerEngine().skipIfEqual(Symbol.RIGHT_PAREN);
            this.parseFlashbackQueryClause();
        } else {
            this.parseQueryTableExpression(sqlStatement, isSingleTableOnly);
            this.parsePivotClause(sqlStatement);
            this.parseFlashbackQueryClause();
        }
    }

    private void parseQueryTableExpression(SQLStatement sqlStatement, boolean isSingleTableOnly) {
        this.parseTableFactor(sqlStatement, isSingleTableOnly);
        this.parseDbLink();
        this.parsePartitionExtensionClause();
        this.parseSampleClause();
    }

    private void parseDbLink() {
        this.getLexerEngine().unsupportedIfEqual(Symbol.AT);
    }

    private void parsePartitionExtensionClause() {
        this.getLexerEngine().unsupportedIfEqual(OracleKeyword.PARTITION, OracleKeyword.SUBPARTITION);
    }

    private void parseSampleClause() {
        this.getLexerEngine().unsupportedIfEqual(OracleKeyword.SAMPLE);
    }

    private void parseFlashbackQueryClause() {
        if (this.isFlashbackQueryClauseForVersions() || this.isFlashbackQueryClauseForAs()) {
            throw new UnsupportedOperationException("Cannot support Flashback Query");
        }
    }

    private boolean isFlashbackQueryClauseForVersions() {
        return this.getLexerEngine().skipIfEqual(OracleKeyword.VERSIONS) && this.getLexerEngine().skipIfEqual(DefaultKeyword.BETWEEN);
    }

    private boolean isFlashbackQueryClauseForAs() {
        return this.getLexerEngine().skipIfEqual(DefaultKeyword.AS) && this.getLexerEngine().skipIfEqual(DefaultKeyword.OF) && (this.getLexerEngine().skipIfEqual(OracleKeyword.SCN) || this.getLexerEngine().skipIfEqual(OracleKeyword.TIMESTAMP));
    }

    private void parsePivotClause(SQLStatement sqlStatement) {
        if (this.getLexerEngine().skipIfEqual(OracleKeyword.PIVOT)) {
            this.getLexerEngine().skipIfEqual(OracleKeyword.XML);
            this.getLexerEngine().skipParentheses(sqlStatement);
        } else if (this.getLexerEngine().skipIfEqual(OracleKeyword.UNPIVOT)) {
            if (this.getLexerEngine().skipIfEqual(OracleKeyword.INCLUDE)) {
                this.getLexerEngine().accept(OracleKeyword.NULLS);
            } else if (this.getLexerEngine().skipIfEqual(OracleKeyword.EXCLUDE)) {
                this.getLexerEngine().accept(OracleKeyword.NULLS);
            }
            this.getLexerEngine().skipParentheses(sqlStatement);
        }
    }
}

