/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.ddl.create.table;

import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.parser.clause.TableReferencesClauseParser;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingException;
import io.shardingsphere.core.parsing.parser.sql.SQLParser;
import io.shardingsphere.core.parsing.parser.sql.ddl.DDLStatement;
import io.shardingsphere.core.rule.ShardingRule;

public abstract class AbstractCreateTableParser
implements SQLParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final TableReferencesClauseParser tableReferencesClauseParser;

    public AbstractCreateTableParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = new TableReferencesClauseParser(shardingRule, lexerEngine);
    }

    @Override
    public DDLStatement parse() {
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenCreateIndexAndKeyword());
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenCreateAndKeyword());
        DDLStatement result = new DDLStatement();
        if (!this.lexerEngine.skipIfEqual(DefaultKeyword.TABLE)) {
            throw new SQLParsingException("Can't support other CREATE grammar unless CREATE TABLE.", new Object[0]);
        }
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenCreateTableAndTableName());
        this.tableReferencesClauseParser.parseSingleTableWithoutAlias(result);
        return result;
    }

    protected abstract Keyword[] getSkippedKeywordsBetweenCreateIndexAndKeyword();

    protected abstract Keyword[] getSkippedKeywordsBetweenCreateAndKeyword();

    protected abstract Keyword[] getSkippedKeywordsBetweenCreateTableAndTableName();

    protected ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    protected LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }

    protected TableReferencesClauseParser getTableReferencesClauseParser() {
        return this.tableReferencesClauseParser;
    }
}

