/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.ddl.drop.index;

import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.lexer.token.Token;
import io.shardingsphere.core.parsing.parser.clause.TableReferencesClauseParser;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingException;
import io.shardingsphere.core.parsing.parser.sql.SQLParser;
import io.shardingsphere.core.parsing.parser.sql.ddl.DDLStatement;
import io.shardingsphere.core.parsing.parser.token.IndexToken;
import io.shardingsphere.core.rule.ShardingRule;

public abstract class AbstractDropIndexParser
implements SQLParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final TableReferencesClauseParser tableReferencesClauseParser;

    public AbstractDropIndexParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = new TableReferencesClauseParser(shardingRule, lexerEngine);
    }

    @Override
    public DDLStatement parse() {
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenDropAndTable());
        DDLStatement result = new DDLStatement();
        if (!this.lexerEngine.skipIfEqual(DefaultKeyword.INDEX)) {
            throw new SQLParsingException("Can't support other DROP grammar unless DROP INDEX.", new Object[0]);
        }
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenDropIndexAndIndexName());
        this.parseIndex(result);
        return result;
    }

    protected Keyword[] getSkippedKeywordsBetweenDropAndTable() {
        return new Keyword[0];
    }

    protected Keyword[] getSkippedKeywordsBetweenDropIndexAndIndexName() {
        return new Keyword[0];
    }

    private void parseIndex(DDLStatement ddlStatement) {
        Token currentToken = this.lexerEngine.getCurrentToken();
        int beginPosition = currentToken.getEndPosition() - currentToken.getLiterals().length();
        String literals = currentToken.getLiterals();
        this.lexerEngine.skipUntil(DefaultKeyword.ON);
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.ON)) {
            this.tableReferencesClauseParser.parseSingleTableWithoutAlias(ddlStatement);
            ddlStatement.getSqlTokens().add(new IndexToken(beginPosition, literals, ddlStatement.getTables().getSingleTableName()));
        } else {
            ddlStatement.getSqlTokens().add(new IndexToken(beginPosition, literals, ""));
        }
    }

    protected ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    protected LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }

    protected TableReferencesClauseParser getTableReferencesClauseParser() {
        return this.tableReferencesClauseParser;
    }
}

