/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.ddl.drop.table;

import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.parser.clause.TableReferencesClauseParser;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingException;
import io.shardingsphere.core.parsing.parser.sql.SQLParser;
import io.shardingsphere.core.parsing.parser.sql.ddl.DDLStatement;
import io.shardingsphere.core.rule.ShardingRule;

public abstract class AbstractDropTableParser
implements SQLParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final TableReferencesClauseParser tableReferencesClauseParser;

    public AbstractDropTableParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = new TableReferencesClauseParser(shardingRule, lexerEngine);
    }

    @Override
    public DDLStatement parse() {
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenDropAndTable());
        DDLStatement result = new DDLStatement();
        if (!this.lexerEngine.skipIfEqual(DefaultKeyword.TABLE)) {
            throw new SQLParsingException("Can't support other DROP grammar unless DROP TABLE.", new Object[0]);
        }
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenDropTableAndTableName());
        this.tableReferencesClauseParser.parseSingleTableWithoutAlias(result);
        return result;
    }

    protected Keyword[] getSkippedKeywordsBetweenDropAndTable() {
        return new Keyword[0];
    }

    protected abstract Keyword[] getSkippedKeywordsBetweenDropTableAndTableName();

    protected ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    protected LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }

    protected TableReferencesClauseParser getTableReferencesClauseParser() {
        return this.tableReferencesClauseParser;
    }
}

