/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.dml.insert;

import com.google.common.base.Optional;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.clause.facade.AbstractInsertClauseParserFacade;
import io.shardingsphere.core.parsing.parser.context.condition.Column;
import io.shardingsphere.core.parsing.parser.sql.SQLParser;
import io.shardingsphere.core.parsing.parser.sql.dml.DMLStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.parsing.parser.token.ItemsToken;
import io.shardingsphere.core.rule.ShardingRule;

public abstract class AbstractInsertParser
implements SQLParser {
    private final ShardingRule shardingRule;
    private final ShardingTableMetaData shardingTableMetaData;
    private final LexerEngine lexerEngine;
    private final AbstractInsertClauseParserFacade insertClauseParserFacade;

    public AbstractInsertParser(ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData, LexerEngine lexerEngine, AbstractInsertClauseParserFacade insertClauseParserFacade) {
        this.shardingRule = shardingRule;
        this.shardingTableMetaData = shardingTableMetaData;
        this.lexerEngine = lexerEngine;
        this.insertClauseParserFacade = insertClauseParserFacade;
    }

    @Override
    public final DMLStatement parse() {
        this.lexerEngine.nextToken();
        InsertStatement result = new InsertStatement();
        this.insertClauseParserFacade.getInsertIntoClauseParser().parse(result);
        this.insertClauseParserFacade.getInsertColumnsClauseParser().parse(result, this.shardingTableMetaData);
        if (this.lexerEngine.equalAny(DefaultKeyword.SELECT, Symbol.LEFT_PAREN)) {
            throw new UnsupportedOperationException("Cannot INSERT SELECT");
        }
        this.insertClauseParserFacade.getInsertValuesClauseParser().parse(result);
        this.insertClauseParserFacade.getInsertSetClauseParser().parse(result);
        this.insertClauseParserFacade.getInsertDuplicateKeyUpdateClauseParser().parse(result);
        this.processGeneratedKey(result);
        return result;
    }

    private void processGeneratedKey(InsertStatement insertStatement) {
        String tableName = insertStatement.getTables().getSingleTableName();
        Optional<Column> generateKeyColumn = this.shardingRule.getGenerateKeyColumn(tableName);
        if (-1 != insertStatement.getGenerateKeyColumnIndex() || !generateKeyColumn.isPresent()) {
            return;
        }
        if (DefaultKeyword.VALUES.equals(insertStatement.getInsertValues().getInsertValues().get(0).getType())) {
            if (!insertStatement.getItemsTokens().isEmpty()) {
                insertStatement.getItemsTokens().get(0).getItems().add(((Column)generateKeyColumn.get()).getName());
            } else {
                ItemsToken columnsToken = new ItemsToken(insertStatement.getColumnsListLastPosition());
                columnsToken.getItems().add(((Column)generateKeyColumn.get()).getName());
                insertStatement.getSqlTokens().add(columnsToken);
            }
        }
    }

    protected ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    protected ShardingTableMetaData getShardingTableMetaData() {
        return this.shardingTableMetaData;
    }

    protected LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }
}

