/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.token;

import io.shardingsphere.core.parsing.parser.token.SQLToken;
import io.shardingsphere.core.util.SQLUtil;
import java.beans.ConstructorProperties;

public final class SchemaToken
implements SQLToken {
    private final int beginPosition;
    private final String originalLiterals;
    private final String tableName;

    public String getSchemaName() {
        return SQLUtil.getExactlyValue(this.originalLiterals);
    }

    public String getTableName() {
        return SQLUtil.getExactlyValue(this.tableName);
    }

    @ConstructorProperties(value={"beginPosition", "originalLiterals", "tableName"})
    public SchemaToken(int beginPosition, String originalLiterals, String tableName) {
        this.beginPosition = beginPosition;
        this.originalLiterals = originalLiterals;
        this.tableName = tableName;
    }

    public String toString() {
        return "SchemaToken(beginPosition=" + this.getBeginPosition() + ", originalLiterals=" + this.getOriginalLiterals() + ", tableName=" + this.getTableName() + ")";
    }

    @Override
    public int getBeginPosition() {
        return this.beginPosition;
    }

    public String getOriginalLiterals() {
        return this.originalLiterals;
    }
}

