/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing;

import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.routing.SQLExecutionUnit;
import io.shardingsphere.core.routing.SQLUnit;
import io.shardingsphere.core.routing.router.sharding.GeneratedKey;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public final class SQLRouteResult {
    private final SQLStatement sqlStatement;
    private final GeneratedKey generatedKey;
    private final Set<SQLExecutionUnit> executionUnits = new LinkedHashSet<SQLExecutionUnit>();

    public SQLRouteResult(SQLStatement sqlStatement) {
        this(sqlStatement, null);
    }

    public Map<String, Collection<SQLUnit>> getSQLUnitGroups() {
        LinkedHashMap<String, Collection<SQLUnit>> result = new LinkedHashMap<String, Collection<SQLUnit>>(this.executionUnits.size(), 1.0f);
        for (SQLExecutionUnit each : this.executionUnits) {
            if (!result.containsKey(each.getDataSource())) {
                result.put(each.getDataSource(), new LinkedList());
            }
            ((Collection)result.get(each.getDataSource())).add(each.getSqlUnit());
        }
        return result;
    }

    @ConstructorProperties(value={"sqlStatement", "generatedKey"})
    public SQLRouteResult(SQLStatement sqlStatement, GeneratedKey generatedKey) {
        this.sqlStatement = sqlStatement;
        this.generatedKey = generatedKey;
    }

    public SQLStatement getSqlStatement() {
        return this.sqlStatement;
    }

    public GeneratedKey getGeneratedKey() {
        return this.generatedKey;
    }

    public Set<SQLExecutionUnit> getExecutionUnits() {
        return this.executionUnits;
    }
}

