/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.router.masterslave;

import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.hint.HintManagerHolder;
import io.shardingsphere.core.routing.SQLExecutionUnit;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.routing.router.masterslave.MasterVisitedManager;
import io.shardingsphere.core.rule.MasterSlaveRule;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public final class ShardingMasterSlaveRouter {
    private final Collection<MasterSlaveRule> masterSlaveRules;

    public SQLRouteResult route(SQLRouteResult sqlRouteResult) {
        for (MasterSlaveRule each : this.masterSlaveRules) {
            this.route(each, sqlRouteResult);
        }
        return sqlRouteResult;
    }

    private void route(MasterSlaveRule masterSlaveRule, SQLRouteResult sqlRouteResult) {
        LinkedList<SQLExecutionUnit> toBeRemoved = new LinkedList<SQLExecutionUnit>();
        LinkedList<SQLExecutionUnit> toBeAdded = new LinkedList<SQLExecutionUnit>();
        for (SQLExecutionUnit each : sqlRouteResult.getExecutionUnits()) {
            if (!masterSlaveRule.getName().equalsIgnoreCase(each.getDataSource())) continue;
            toBeRemoved.add(each);
            if (this.isMasterRoute(sqlRouteResult.getSqlStatement().getType())) {
                MasterVisitedManager.setMasterVisited();
                toBeAdded.add(new SQLExecutionUnit(masterSlaveRule.getMasterDataSourceName(), each.getSqlUnit()));
                continue;
            }
            toBeAdded.add(new SQLExecutionUnit(masterSlaveRule.getLoadBalanceAlgorithm().getDataSource(masterSlaveRule.getName(), masterSlaveRule.getMasterDataSourceName(), new ArrayList<String>(masterSlaveRule.getSlaveDataSourceNames())), each.getSqlUnit()));
        }
        sqlRouteResult.getExecutionUnits().removeAll(toBeRemoved);
        sqlRouteResult.getExecutionUnits().addAll(toBeAdded);
    }

    private boolean isMasterRoute(SQLType sqlType) {
        return SQLType.DQL != sqlType || MasterVisitedManager.isMasterVisited() || HintManagerHolder.isMasterRouteOnly();
    }

    @ConstructorProperties(value={"masterSlaveRules"})
    public ShardingMasterSlaveRouter(Collection<MasterSlaveRule> masterSlaveRules) {
        this.masterSlaveRules = masterSlaveRules;
    }
}

