/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.router.sharding;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.optimizer.OptimizeEngineFactory;
import io.shardingsphere.core.optimizer.condition.ShardingConditions;
import io.shardingsphere.core.parsing.SQLParsingEngine;
import io.shardingsphere.core.parsing.parser.context.condition.Column;
import io.shardingsphere.core.parsing.parser.context.condition.GeneratedKeyCondition;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowDatabasesStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.ShowTablesStatement;
import io.shardingsphere.core.parsing.parser.dialect.mysql.statement.UseStatement;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.DALStatement;
import io.shardingsphere.core.parsing.parser.sql.dcl.DCLStatement;
import io.shardingsphere.core.parsing.parser.sql.ddl.DDLStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.rewrite.SQLBuilder;
import io.shardingsphere.core.rewrite.SQLRewriteEngine;
import io.shardingsphere.core.routing.SQLExecutionUnit;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.routing.router.sharding.GeneratedKey;
import io.shardingsphere.core.routing.router.sharding.ShardingRouter;
import io.shardingsphere.core.routing.type.RoutingEngine;
import io.shardingsphere.core.routing.type.RoutingResult;
import io.shardingsphere.core.routing.type.TableUnit;
import io.shardingsphere.core.routing.type.broadcast.DatabaseBroadcastRoutingEngine;
import io.shardingsphere.core.routing.type.broadcast.InstanceBroadcastRoutingEngine;
import io.shardingsphere.core.routing.type.broadcast.TableBroadcastRoutingEngine;
import io.shardingsphere.core.routing.type.complex.ComplexRoutingEngine;
import io.shardingsphere.core.routing.type.ignore.IgnoreRoutingEngine;
import io.shardingsphere.core.routing.type.standard.StandardRoutingEngine;
import io.shardingsphere.core.routing.type.unicast.UnicastRoutingEngine;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.rule.TableRule;
import io.shardingsphere.core.util.SQLLogger;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class ParsingSQLRouter
implements ShardingRouter {
    private final ShardingRule shardingRule;
    private final ShardingTableMetaData shardingTableMetaData;
    private final DatabaseType databaseType;
    private final boolean showSQL;
    private final List<Number> generatedKeys = new LinkedList<Number>();
    private final ShardingDataSourceMetaData shardingDataSourceMetaData;

    @Override
    public SQLStatement parse(String logicSQL, boolean useCache) {
        return new SQLParsingEngine(this.databaseType, logicSQL, this.shardingRule, this.shardingTableMetaData).parse(useCache);
    }

    @Override
    public SQLRouteResult route(String logicSQL, List<Object> parameters, SQLStatement sqlStatement) {
        GeneratedKey generatedKey = null;
        if (sqlStatement instanceof InsertStatement) {
            generatedKey = this.getGenerateKey(this.shardingRule, (InsertStatement)sqlStatement, parameters);
        }
        SQLRouteResult result = new SQLRouteResult(sqlStatement, generatedKey);
        ShardingConditions shardingConditions = OptimizeEngineFactory.newInstance(this.shardingRule, sqlStatement, parameters, generatedKey).optimize();
        if (null != generatedKey) {
            this.setGeneratedKeys(result, generatedKey);
        }
        RoutingResult routingResult = this.route(sqlStatement, shardingConditions);
        SQLRewriteEngine rewriteEngine = new SQLRewriteEngine(this.shardingRule, logicSQL, this.databaseType, sqlStatement, shardingConditions, parameters);
        boolean isSingleRouting = routingResult.isSingleRouting();
        if (sqlStatement instanceof SelectStatement && null != ((SelectStatement)sqlStatement).getLimit()) {
            this.processLimit(parameters, (SelectStatement)sqlStatement, isSingleRouting);
        }
        SQLBuilder sqlBuilder = rewriteEngine.rewrite(!isSingleRouting);
        for (TableUnit each : routingResult.getTableUnits().getTableUnits()) {
            result.getExecutionUnits().add(new SQLExecutionUnit(each.getDataSourceName(), rewriteEngine.generateSQL(each, sqlBuilder, this.shardingDataSourceMetaData)));
        }
        if (this.showSQL) {
            SQLLogger.logSQL(logicSQL, sqlStatement, result.getExecutionUnits());
        }
        return result;
    }

    private RoutingResult route(SQLStatement sqlStatement, ShardingConditions shardingConditions) {
        Collection<String> tableNames = sqlStatement.getTables().getTableNames();
        RoutingEngine routingEngine = sqlStatement instanceof UseStatement ? new IgnoreRoutingEngine() : (sqlStatement instanceof DDLStatement || sqlStatement instanceof DCLStatement && ((DCLStatement)sqlStatement).isGrantForSingleTable() ? new TableBroadcastRoutingEngine(this.shardingRule, sqlStatement) : (sqlStatement instanceof ShowDatabasesStatement || sqlStatement instanceof ShowTablesStatement ? new DatabaseBroadcastRoutingEngine(this.shardingRule) : (sqlStatement instanceof DCLStatement ? new InstanceBroadcastRoutingEngine(this.shardingRule, this.shardingDataSourceMetaData) : (shardingConditions.isAlwaysFalse() ? new UnicastRoutingEngine(this.shardingRule, tableNames) : (sqlStatement instanceof DALStatement ? new UnicastRoutingEngine(this.shardingRule, tableNames) : (tableNames.isEmpty() && sqlStatement instanceof SelectStatement ? new UnicastRoutingEngine(this.shardingRule, tableNames) : (tableNames.isEmpty() ? new DatabaseBroadcastRoutingEngine(this.shardingRule) : (1 == tableNames.size() || this.shardingRule.isAllBindingTables(tableNames) || this.shardingRule.isAllInDefaultDataSource(tableNames) ? new StandardRoutingEngine(this.shardingRule, tableNames.iterator().next(), shardingConditions) : new ComplexRoutingEngine(this.shardingRule, tableNames, shardingConditions)))))))));
        return routingEngine.route();
    }

    private GeneratedKey getGenerateKey(ShardingRule shardingRule, InsertStatement insertStatement, List<Object> parameters) {
        GeneratedKey result = null;
        if (-1 != insertStatement.getGenerateKeyColumnIndex()) {
            for (GeneratedKeyCondition generatedKeyCondition : insertStatement.getGeneratedKeyConditions()) {
                if (null == result) {
                    result = new GeneratedKey(generatedKeyCondition.getColumn());
                }
                if (-1 == generatedKeyCondition.getIndex()) {
                    result.getGeneratedKeys().add(generatedKeyCondition.getValue());
                    continue;
                }
                result.getGeneratedKeys().add((Number)parameters.get(generatedKeyCondition.getIndex()));
            }
            return result;
        }
        String logicTableName = insertStatement.getTables().getSingleTableName();
        Optional<TableRule> tableRule = shardingRule.tryFindTableRuleByLogicTable(logicTableName);
        if (!tableRule.isPresent()) {
            return null;
        }
        Optional<Column> generateKeyColumn = shardingRule.getGenerateKeyColumn(logicTableName);
        if (generateKeyColumn.isPresent()) {
            result = new GeneratedKey((Column)generateKeyColumn.get());
            for (int i = 0; i < insertStatement.getInsertValues().getInsertValues().size(); ++i) {
                result.getGeneratedKeys().add(shardingRule.generateKey(logicTableName));
            }
        }
        return result;
    }

    private void setGeneratedKeys(SQLRouteResult sqlRouteResult, GeneratedKey generatedKey) {
        this.generatedKeys.addAll(generatedKey.getGeneratedKeys());
        sqlRouteResult.getGeneratedKey().getGeneratedKeys().clear();
        sqlRouteResult.getGeneratedKey().getGeneratedKeys().addAll(this.generatedKeys);
    }

    private void processLimit(List<Object> parameters, SelectStatement selectStatement, boolean isSingleRouting) {
        if (isSingleRouting) {
            selectStatement.setLimit(null);
            return;
        }
        boolean isNeedFetchAll = (!selectStatement.getGroupByItems().isEmpty() || !selectStatement.getAggregationSelectItems().isEmpty()) && !selectStatement.isSameGroupByAndOrderByItems();
        selectStatement.getLimit().processParameters(parameters, isNeedFetchAll);
    }

    @ConstructorProperties(value={"shardingRule", "shardingTableMetaData", "databaseType", "showSQL", "shardingDataSourceMetaData"})
    public ParsingSQLRouter(ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData, DatabaseType databaseType, boolean showSQL, ShardingDataSourceMetaData shardingDataSourceMetaData) {
        this.shardingRule = shardingRule;
        this.shardingTableMetaData = shardingTableMetaData;
        this.databaseType = databaseType;
        this.showSQL = showSQL;
        this.shardingDataSourceMetaData = shardingDataSourceMetaData;
    }
}

