/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.strategy.complex;

import com.google.common.base.Preconditions;
import io.shardingsphere.core.api.algorithm.sharding.ShardingValue;
import io.shardingsphere.core.api.algorithm.sharding.complex.ComplexKeysShardingAlgorithm;
import io.shardingsphere.core.api.config.strategy.ComplexShardingStrategyConfiguration;
import io.shardingsphere.core.routing.strategy.ShardingStrategy;
import io.shardingsphere.core.util.StringUtil;
import java.util.Collection;
import java.util.TreeSet;

public final class ComplexShardingStrategy
implements ShardingStrategy {
    private final Collection<String> shardingColumns;
    private final ComplexKeysShardingAlgorithm shardingAlgorithm;

    public ComplexShardingStrategy(ComplexShardingStrategyConfiguration complexShardingStrategyConfig) {
        Preconditions.checkNotNull((Object)complexShardingStrategyConfig.getShardingColumns(), (Object)"Sharding columns cannot be null.");
        Preconditions.checkNotNull((Object)complexShardingStrategyConfig.getShardingAlgorithm(), (Object)"Sharding algorithm cannot be null.");
        this.shardingColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.shardingColumns.addAll(StringUtil.splitWithComma(complexShardingStrategyConfig.getShardingColumns()));
        this.shardingAlgorithm = complexShardingStrategyConfig.getShardingAlgorithm();
    }

    @Override
    public Collection<String> doSharding(Collection<String> availableTargetNames, Collection<ShardingValue> shardingValues) {
        Collection<String> shardingResult = this.shardingAlgorithm.doSharding(availableTargetNames, shardingValues);
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(shardingResult);
        return result;
    }

    @Override
    public Collection<String> getShardingColumns() {
        return this.shardingColumns;
    }
}

