/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.rule;

import com.google.common.base.Preconditions;
import io.shardingsphere.core.api.algorithm.masterslave.MasterSlaveLoadBalanceAlgorithm;
import io.shardingsphere.core.api.algorithm.masterslave.MasterSlaveLoadBalanceAlgorithmType;
import io.shardingsphere.core.api.config.MasterSlaveRuleConfiguration;
import java.util.Collection;

public final class MasterSlaveRule {
    private final String name;
    private final String masterDataSourceName;
    private final Collection<String> slaveDataSourceNames;
    private final MasterSlaveLoadBalanceAlgorithm loadBalanceAlgorithm;

    public MasterSlaveRule(MasterSlaveRuleConfiguration config) {
        Preconditions.checkNotNull((Object)config.getName(), (Object)"Master-slave rule name cannot be null.");
        Preconditions.checkNotNull((Object)config.getMasterDataSourceName(), (Object)"Master data source name cannot be null.");
        Preconditions.checkNotNull(config.getSlaveDataSourceNames(), (Object)"Slave data source names cannot be null.");
        Preconditions.checkState((!config.getSlaveDataSourceNames().isEmpty() ? 1 : 0) != 0, (Object)"Slave data source names cannot be empty.");
        this.name = config.getName();
        this.masterDataSourceName = config.getMasterDataSourceName();
        this.slaveDataSourceNames = config.getSlaveDataSourceNames();
        this.loadBalanceAlgorithm = null == config.getLoadBalanceAlgorithm() ? MasterSlaveLoadBalanceAlgorithmType.getDefaultAlgorithmType().getAlgorithm() : config.getLoadBalanceAlgorithm();
    }

    public boolean containDataSourceName(String dataSourceName) {
        return this.masterDataSourceName.equals(dataSourceName) || this.slaveDataSourceNames.contains(dataSourceName);
    }

    public String getName() {
        return this.name;
    }

    public String getMasterDataSourceName() {
        return this.masterDataSourceName;
    }

    public Collection<String> getSlaveDataSourceNames() {
        return this.slaveDataSourceNames;
    }

    public MasterSlaveLoadBalanceAlgorithm getLoadBalanceAlgorithm() {
        return this.loadBalanceAlgorithm;
    }
}

