/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.transaction.listener;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import io.shardingsphere.core.transaction.TransactionContextHolder;
import io.shardingsphere.core.transaction.event.TransactionEvent;
import io.shardingsphere.core.transaction.spi.TransactionManager;
import java.sql.SQLException;

public final class TransactionListener {
    private static final TransactionListener INSTANCE = new TransactionListener();

    public static TransactionListener getInstance() {
        return INSTANCE;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void listen(TransactionEvent transactionEvent) throws SQLException {
        TransactionManager transactionManager = TransactionContextHolder.get().getTransactionManager();
        switch (transactionEvent.getTclType()) {
            case BEGIN: {
                transactionManager.begin(transactionEvent);
                break;
            }
            case COMMIT: {
                transactionManager.commit(transactionEvent);
                break;
            }
            case ROLLBACK: {
                transactionManager.rollback(transactionEvent);
                break;
            }
        }
    }

    private TransactionListener() {
    }
}

