/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.yaml.sharding;

import io.shardingsphere.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingsphere.core.api.config.ShardingRuleConfiguration;
import io.shardingsphere.core.api.config.TableRuleConfiguration;
import io.shardingsphere.core.keygen.KeyGeneratorFactory;
import io.shardingsphere.core.yaml.masterslave.YamlMasterSlaveRuleConfiguration;
import io.shardingsphere.core.yaml.sharding.YamlShardingStrategyConfiguration;
import io.shardingsphere.core.yaml.sharding.YamlTableRuleConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class YamlShardingRuleConfiguration {
    private String defaultDataSourceName;
    private Map<String, YamlTableRuleConfiguration> tables = new LinkedHashMap<String, YamlTableRuleConfiguration>();
    private List<String> bindingTables = new ArrayList<String>();
    private YamlShardingStrategyConfiguration defaultDatabaseStrategy;
    private YamlShardingStrategyConfiguration defaultTableStrategy;
    private String defaultKeyGeneratorClassName;
    private Map<String, YamlMasterSlaveRuleConfiguration> masterSlaveRules = new LinkedHashMap<String, YamlMasterSlaveRuleConfiguration>();
    private Map<String, Object> configMap = new LinkedHashMap<String, Object>();
    private Properties props = new Properties();

    public YamlShardingRuleConfiguration(ShardingRuleConfiguration shardingRuleConfiguration, Map<String, Object> configMap, Properties props) {
        this.defaultDataSourceName = shardingRuleConfiguration.getDefaultDataSourceName();
        for (TableRuleConfiguration tableRuleConfiguration : shardingRuleConfiguration.getTableRuleConfigs()) {
            this.tables.put(tableRuleConfiguration.getLogicTable(), new YamlTableRuleConfiguration(tableRuleConfiguration));
        }
        this.bindingTables.addAll(shardingRuleConfiguration.getBindingTableGroups());
        this.defaultDatabaseStrategy = new YamlShardingStrategyConfiguration(shardingRuleConfiguration.getDefaultDatabaseShardingStrategyConfig());
        this.defaultTableStrategy = new YamlShardingStrategyConfiguration(shardingRuleConfiguration.getDefaultTableShardingStrategyConfig());
        this.defaultKeyGeneratorClassName = null == shardingRuleConfiguration.getDefaultKeyGenerator() ? null : shardingRuleConfiguration.getDefaultKeyGenerator().getClass().getName();
        for (MasterSlaveRuleConfiguration masterSlaveRuleConfiguration : shardingRuleConfiguration.getMasterSlaveRuleConfigs()) {
            this.masterSlaveRules.put(masterSlaveRuleConfiguration.getName(), new YamlMasterSlaveRuleConfiguration(masterSlaveRuleConfiguration, new HashMap<String, Object>(), new Properties()));
        }
        this.configMap = configMap;
        this.props = props;
    }

    public ShardingRuleConfiguration getShardingRuleConfiguration() {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        result.setDefaultDataSourceName(this.defaultDataSourceName);
        for (Map.Entry<String, YamlTableRuleConfiguration> entry : this.tables.entrySet()) {
            YamlTableRuleConfiguration tableRuleConfig = entry.getValue();
            tableRuleConfig.setLogicTable(entry.getKey());
            result.getTableRuleConfigs().add(tableRuleConfig.build());
        }
        result.getBindingTableGroups().addAll(this.bindingTables);
        if (null != this.defaultDatabaseStrategy) {
            result.setDefaultDatabaseShardingStrategyConfig(this.defaultDatabaseStrategy.build());
        }
        if (null != this.defaultTableStrategy) {
            result.setDefaultTableShardingStrategyConfig(this.defaultTableStrategy.build());
        }
        if (null != this.defaultKeyGeneratorClassName) {
            result.setDefaultKeyGenerator(KeyGeneratorFactory.newInstance(this.defaultKeyGeneratorClassName));
        }
        LinkedList<MasterSlaveRuleConfiguration> masterSlaveRuleConfigs = new LinkedList<MasterSlaveRuleConfiguration>();
        for (Map.Entry<String, YamlMasterSlaveRuleConfiguration> entry : this.masterSlaveRules.entrySet()) {
            YamlMasterSlaveRuleConfiguration each = entry.getValue();
            each.setName(entry.getKey());
            masterSlaveRuleConfigs.add(entry.getValue().getMasterSlaveRuleConfiguration());
        }
        result.setMasterSlaveRuleConfigs(masterSlaveRuleConfigs);
        return result;
    }

    public YamlShardingRuleConfiguration() {
    }

    public String getDefaultDataSourceName() {
        return this.defaultDataSourceName;
    }

    public Map<String, YamlTableRuleConfiguration> getTables() {
        return this.tables;
    }

    public List<String> getBindingTables() {
        return this.bindingTables;
    }

    public YamlShardingStrategyConfiguration getDefaultDatabaseStrategy() {
        return this.defaultDatabaseStrategy;
    }

    public YamlShardingStrategyConfiguration getDefaultTableStrategy() {
        return this.defaultTableStrategy;
    }

    public String getDefaultKeyGeneratorClassName() {
        return this.defaultKeyGeneratorClassName;
    }

    public Map<String, YamlMasterSlaveRuleConfiguration> getMasterSlaveRules() {
        return this.masterSlaveRules;
    }

    public Map<String, Object> getConfigMap() {
        return this.configMap;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setDefaultDataSourceName(String defaultDataSourceName) {
        this.defaultDataSourceName = defaultDataSourceName;
    }

    public void setTables(Map<String, YamlTableRuleConfiguration> tables) {
        this.tables = tables;
    }

    public void setBindingTables(List<String> bindingTables) {
        this.bindingTables = bindingTables;
    }

    public void setDefaultDatabaseStrategy(YamlShardingStrategyConfiguration defaultDatabaseStrategy) {
        this.defaultDatabaseStrategy = defaultDatabaseStrategy;
    }

    public void setDefaultTableStrategy(YamlShardingStrategyConfiguration defaultTableStrategy) {
        this.defaultTableStrategy = defaultTableStrategy;
    }

    public void setDefaultKeyGeneratorClassName(String defaultKeyGeneratorClassName) {
        this.defaultKeyGeneratorClassName = defaultKeyGeneratorClassName;
    }

    public void setMasterSlaveRules(Map<String, YamlMasterSlaveRuleConfiguration> masterSlaveRules) {
        this.masterSlaveRules = masterSlaveRules;
    }

    public void setConfigMap(Map<String, Object> configMap) {
        this.configMap = configMap;
    }

    public void setProps(Properties props) {
        this.props = props;
    }
}

