/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.event;

import com.google.common.base.Optional;
import io.shardingsphere.core.executor.event.AbstractExecutionEvent;
import io.shardingsphere.core.routing.SQLUnit;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractSQLExecutionEvent
extends AbstractExecutionEvent {
    private final String dataSource;
    private final SQLUnit sqlUnit;
    private final List<Object> parameters;

    public Optional<SQLException> getException() {
        Optional<? extends Exception> ex = super.getException();
        if (ex.isPresent()) {
            return Optional.of((Object)((SQLException)ex.get()));
        }
        return Optional.absent();
    }

    @ConstructorProperties(value={"dataSource", "sqlUnit", "parameters"})
    public AbstractSQLExecutionEvent(String dataSource, SQLUnit sqlUnit, List<Object> parameters) {
        this.dataSource = dataSource;
        this.sqlUnit = sqlUnit;
        this.parameters = parameters;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public SQLUnit getSqlUnit() {
        return this.sqlUnit;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }
}

