/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.type.statement;

import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.executor.BaseStatementUnit;
import io.shardingsphere.core.executor.ExecuteCallback;
import io.shardingsphere.core.executor.ExecutorEngine;
import io.shardingsphere.core.executor.type.statement.StatementUnit;
import java.beans.ConstructorProperties;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;

public final class StatementExecutor {
    private final ExecutorEngine executorEngine;
    private final SQLType sqlType;
    private final Collection<StatementUnit> statementUnits;

    public List<ResultSet> executeQuery() throws SQLException {
        return this.executorEngine.execute(this.sqlType, this.statementUnits, new ExecuteCallback<ResultSet>(){

            @Override
            public ResultSet execute(BaseStatementUnit baseStatementUnit) throws Exception {
                return baseStatementUnit.getStatement().executeQuery(baseStatementUnit.getSqlExecutionUnit().getSqlUnit().getSql());
            }
        });
    }

    public int executeUpdate() throws SQLException {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql);
            }
        });
    }

    public int executeUpdate(final int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, autoGeneratedKeys);
            }
        });
    }

    public int executeUpdate(final int[] columnIndexes) throws SQLException {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, columnIndexes);
            }
        });
    }

    public int executeUpdate(final String[] columnNames) throws SQLException {
        return this.executeUpdate(new Updater(){

            @Override
            public int executeUpdate(Statement statement, String sql) throws SQLException {
                return statement.executeUpdate(sql, columnNames);
            }
        });
    }

    private int executeUpdate(final Updater updater) throws SQLException {
        List<Integer> results = this.executorEngine.execute(this.sqlType, this.statementUnits, new ExecuteCallback<Integer>(){

            @Override
            public Integer execute(BaseStatementUnit baseStatementUnit) throws Exception {
                return updater.executeUpdate(baseStatementUnit.getStatement(), baseStatementUnit.getSqlExecutionUnit().getSqlUnit().getSql());
            }
        });
        return this.accumulate(results);
    }

    private int accumulate(List<Integer> results) {
        int result = 0;
        for (Integer each : results) {
            result += null == each ? 0 : each;
        }
        return result;
    }

    public boolean execute() throws SQLException {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql);
            }
        });
    }

    public boolean execute(final int autoGeneratedKeys) throws SQLException {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, autoGeneratedKeys);
            }
        });
    }

    public boolean execute(final int[] columnIndexes) throws SQLException {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, columnIndexes);
            }
        });
    }

    public boolean execute(final String[] columnNames) throws SQLException {
        return this.execute(new Executor(){

            @Override
            public boolean execute(Statement statement, String sql) throws SQLException {
                return statement.execute(sql, columnNames);
            }
        });
    }

    private boolean execute(final Executor executor) throws SQLException {
        List<Boolean> result = this.executorEngine.execute(this.sqlType, this.statementUnits, new ExecuteCallback<Boolean>(){

            @Override
            public Boolean execute(BaseStatementUnit baseStatementUnit) throws SQLException {
                return executor.execute(baseStatementUnit.getStatement(), baseStatementUnit.getSqlExecutionUnit().getSqlUnit().getSql());
            }
        });
        if (null == result || result.isEmpty() || null == result.get(0)) {
            return false;
        }
        return result.get(0);
    }

    @ConstructorProperties(value={"executorEngine", "sqlType", "statementUnits"})
    public StatementExecutor(ExecutorEngine executorEngine, SQLType sqlType, Collection<StatementUnit> statementUnits) {
        this.executorEngine = executorEngine;
        this.sqlType = sqlType;
        this.statementUnits = statementUnits;
    }

    private static interface Executor {
        public boolean execute(Statement var1, String var2) throws SQLException;
    }

    private static interface Updater {
        public int executeUpdate(Statement var1, String var2) throws SQLException;
    }
}

