/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.core;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.executor.ExecutorEngine;
import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.rule.ShardingRule;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;

public final class ShardingContext {
    private final Map<String, DataSource> dataSourceMap;
    private final ShardingRule shardingRule;
    private final DatabaseType databaseType;
    private final ExecutorEngine executorEngine;
    private final boolean showSQL;
    private final ShardingMetaData metaData;

    public ShardingContext(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule, DatabaseType databaseType, ExecutorEngine executorEngine, ShardingTableMetaData shardingTableMetaData, boolean showSQL) {
        this.dataSourceMap = dataSourceMap;
        this.shardingRule = shardingRule;
        this.databaseType = databaseType;
        this.executorEngine = executorEngine;
        this.showSQL = showSQL;
        this.metaData = new ShardingMetaData(new ShardingDataSourceMetaData(ShardingContext.getDataSourceURLs(dataSourceMap), shardingRule, databaseType), shardingTableMetaData);
    }

    private static Map<String, String> getDataSourceURLs(Map<String, DataSource> dataSourceMap) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(dataSourceMap.size(), 1.0f);
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            result.put(entry.getKey(), ShardingContext.getDataSourceURL(entry.getValue()));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getDataSourceURL(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            String string = connection.getMetaData().getURL();
            return string;
        }
        catch (SQLException ex) {
            throw new ShardingException((Exception)ex);
        }
    }

    @ConstructorProperties(value={"dataSourceMap", "shardingRule", "databaseType", "executorEngine", "showSQL", "metaData"})
    public ShardingContext(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule, DatabaseType databaseType, ExecutorEngine executorEngine, boolean showSQL, ShardingMetaData metaData) {
        this.dataSourceMap = dataSourceMap;
        this.shardingRule = shardingRule;
        this.databaseType = databaseType;
        this.executorEngine = executorEngine;
        this.showSQL = showSQL;
        this.metaData = metaData;
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public ExecutorEngine getExecutorEngine() {
        return this.executorEngine;
    }

    public boolean isShowSQL() {
        return this.showSQL;
    }

    public ShardingMetaData getMetaData() {
        return this.metaData;
    }
}

