/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.core.connection;

import io.shardingsphere.core.jdbc.adapter.AbstractConnectionAdapter;
import io.shardingsphere.core.jdbc.core.ShardingContext;
import io.shardingsphere.core.jdbc.core.statement.ShardingPreparedStatement;
import io.shardingsphere.core.jdbc.core.statement.ShardingStatement;
import io.shardingsphere.core.rule.DataNode;
import io.shardingsphere.core.rule.MasterSlaveRule;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public final class ShardingConnection
extends AbstractConnectionAdapter {
    private final ShardingContext shardingContext;

    public void release(Connection connection) {
        this.removeCache(connection);
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Map<String, Connection> getConnections(String logicTableName) throws SQLException {
        HashMap<String, Connection> result = new HashMap<String, Connection>();
        for (DataNode each : this.shardingContext.getShardingRule().getTableRuleByLogicTableName(logicTableName).getActualDataNodes()) {
            String dataSourceName = this.shardingContext.getShardingRule().getShardingDataSourceNames().getRawMasterDataSourceName(each.getDataSourceName());
            result.put(dataSourceName, this.getConnection(dataSourceName));
        }
        return result;
    }

    @Override
    protected Map<String, DataSource> getDataSourceMap() {
        return this.shardingContext.getDataSourceMap();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        Collection masterSlaveRules = this.shardingContext.getShardingRule().getMasterSlaveRules();
        if (masterSlaveRules.isEmpty()) {
            return this.getConnection(this.shardingContext.getDataSourceMap().keySet().iterator().next()).getMetaData();
        }
        for (MasterSlaveRule each : masterSlaveRules) {
            if (!this.getDataSourceMap().containsKey(each.getMasterDataSourceName())) continue;
            return this.getConnection(each.getMasterDataSourceName()).getMetaData();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) {
        return new ShardingPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
        return new ShardingPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new ShardingPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) {
        return new ShardingPreparedStatement(this, sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) {
        return new ShardingPreparedStatement(this, sql, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) {
        return new ShardingPreparedStatement(this, sql, 1);
    }

    @Override
    public Statement createStatement() {
        return new ShardingStatement(this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) {
        return new ShardingStatement(this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new ShardingStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @ConstructorProperties(value={"shardingContext"})
    public ShardingConnection(ShardingContext shardingContext) {
        this.shardingContext = shardingContext;
    }

    public ShardingContext getShardingContext() {
        return this.shardingContext;
    }
}

