/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.core.datasource;

import io.shardingsphere.core.api.ConfigMapContext;
import io.shardingsphere.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingsphere.core.constant.ShardingProperties;
import io.shardingsphere.core.constant.ShardingPropertiesConstant;
import io.shardingsphere.core.jdbc.adapter.AbstractDataSourceAdapter;
import io.shardingsphere.core.jdbc.core.connection.MasterSlaveConnection;
import io.shardingsphere.core.rule.MasterSlaveRule;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class MasterSlaveDataSource
extends AbstractDataSourceAdapter {
    private Map<String, DataSource> dataSourceMap;
    private MasterSlaveRule masterSlaveRule;
    private ShardingProperties shardingProperties;

    public MasterSlaveDataSource(Map<String, DataSource> dataSourceMap, MasterSlaveRuleConfiguration masterSlaveRuleConfig, Map<String, Object> configMap, Properties props) throws SQLException {
        super(MasterSlaveDataSource.getAllDataSources(dataSourceMap, masterSlaveRuleConfig.getMasterDataSourceName(), masterSlaveRuleConfig.getSlaveDataSourceNames()));
        this.dataSourceMap = dataSourceMap;
        this.masterSlaveRule = new MasterSlaveRule(masterSlaveRuleConfig);
        if (!configMap.isEmpty()) {
            ConfigMapContext.getInstance().getMasterSlaveConfig().putAll(configMap);
        }
        this.shardingProperties = new ShardingProperties(null == props ? new Properties() : props);
    }

    private static Collection<DataSource> getAllDataSources(Map<String, DataSource> dataSourceMap, String masterDataSourceName, Collection<String> slaveDataSourceNames) {
        LinkedList<DataSource> result = new LinkedList<DataSource>();
        result.add(dataSourceMap.get(masterDataSourceName));
        for (String each : slaveDataSourceNames) {
            result.add(dataSourceMap.get(each));
        }
        return result;
    }

    public Map<String, DataSource> getAllDataSources() {
        HashMap<String, DataSource> result = new HashMap<String, DataSource>(this.masterSlaveRule.getSlaveDataSourceNames().size() + 1, 1.0f);
        result.put(this.masterSlaveRule.getMasterDataSourceName(), this.dataSourceMap.get(this.masterSlaveRule.getMasterDataSourceName()));
        for (String each : this.masterSlaveRule.getSlaveDataSourceNames()) {
            result.put(each, this.dataSourceMap.get(each));
        }
        return result;
    }

    public void renew(Map<String, DataSource> dataSourceMap, MasterSlaveRuleConfiguration masterSlaveRuleConfig) {
        this.dataSourceMap = dataSourceMap;
        this.masterSlaveRule = new MasterSlaveRule(masterSlaveRuleConfig);
    }

    @Override
    public MasterSlaveConnection getConnection() {
        return new MasterSlaveConnection(this);
    }

    public boolean showSQL() {
        return (Boolean)this.shardingProperties.getValue(ShardingPropertiesConstant.SQL_SHOW);
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public MasterSlaveRule getMasterSlaveRule() {
        return this.masterSlaveRule;
    }

    public ShardingProperties getShardingProperties() {
        return this.shardingProperties;
    }
}

