/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.core.datasource;

import io.shardingsphere.core.api.ConfigMapContext;
import io.shardingsphere.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingsphere.core.api.config.ShardingRuleConfiguration;
import io.shardingsphere.core.constant.ShardingProperties;
import io.shardingsphere.core.constant.ShardingPropertiesConstant;
import io.shardingsphere.core.executor.ExecutorEngine;
import io.shardingsphere.core.jdbc.adapter.AbstractDataSourceAdapter;
import io.shardingsphere.core.jdbc.core.ShardingContext;
import io.shardingsphere.core.jdbc.core.connection.ShardingConnection;
import io.shardingsphere.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingsphere.core.jdbc.metadata.DataSourceMapTableMetaDataConnectionManager;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataConnectionManager;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataInitializer;
import io.shardingsphere.core.rule.MasterSlaveRule;
import io.shardingsphere.core.rule.ShardingRule;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class ShardingDataSource
extends AbstractDataSourceAdapter
implements AutoCloseable {
    private ShardingProperties shardingProperties;
    private ExecutorEngine executorEngine;
    private ShardingContext shardingContext;

    public ShardingDataSource(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule) throws SQLException {
        this(dataSourceMap, shardingRule, new ConcurrentHashMap<String, Object>(), new Properties());
    }

    public ShardingDataSource(Map<String, DataSource> dataSourceMap, ShardingRule shardingRule, Map<String, Object> configMap, Properties props) throws SQLException {
        super(dataSourceMap.values());
        if (!configMap.isEmpty()) {
            ConfigMapContext.getInstance().getShardingConfig().putAll(configMap);
        }
        this.shardingProperties = new ShardingProperties(null == props ? new Properties() : props);
        int executorSize = (Integer)this.shardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE);
        this.executorEngine = new ExecutorEngine(executorSize);
        ShardingTableMetaData shardingTableMetaData = new ShardingTableMetaData(new TableMetaDataInitializer(this.executorEngine.getExecutorService(), (TableMetaDataConnectionManager)new DataSourceMapTableMetaDataConnectionManager(dataSourceMap)).load(shardingRule));
        boolean showSQL = (Boolean)this.shardingProperties.getValue(ShardingPropertiesConstant.SQL_SHOW);
        this.shardingContext = new ShardingContext(dataSourceMap, shardingRule, this.getDatabaseType(), this.executorEngine, shardingTableMetaData, showSQL);
    }

    public void renew(Map<String, DataSource> newDataSourceMap, ShardingRule newShardingRule, Properties newProps) {
        int newExecutorSize;
        ShardingProperties newShardingProperties = new ShardingProperties(null == newProps ? new Properties() : newProps);
        int originalExecutorSize = (Integer)this.shardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE);
        if (originalExecutorSize != (newExecutorSize = ((Integer)newShardingProperties.getValue(ShardingPropertiesConstant.EXECUTOR_SIZE)).intValue())) {
            ExecutorEngine originalExecutorEngine = this.executorEngine;
            this.executorEngine = new ExecutorEngine(newExecutorSize);
            originalExecutorEngine.close();
        }
        boolean newShowSQL = (Boolean)newShardingProperties.getValue(ShardingPropertiesConstant.SQL_SHOW);
        ShardingTableMetaData shardingMetaData = new ShardingTableMetaData(new TableMetaDataInitializer(this.executorEngine.getExecutorService(), (TableMetaDataConnectionManager)new DataSourceMapTableMetaDataConnectionManager(newDataSourceMap)).load(newShardingRule));
        this.shardingProperties = newShardingProperties;
        this.shardingContext = new ShardingContext(newDataSourceMap, newShardingRule, this.getDatabaseType(), this.executorEngine, shardingMetaData, newShowSQL);
    }

    @Override
    public ShardingConnection getConnection() {
        return new ShardingConnection(this.shardingContext);
    }

    @Override
    public void close() {
        this.executorEngine.close();
    }

    protected static Map<String, DataSource> getRawDataSourceMap(Map<String, DataSource> dataSourceMap) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>();
        if (null == dataSourceMap) {
            return result;
        }
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            String dataSourceName = entry.getKey();
            DataSource dataSource = entry.getValue();
            if (dataSource instanceof MasterSlaveDataSource) {
                result.putAll(((MasterSlaveDataSource)dataSource).getAllDataSources());
                continue;
            }
            result.put(dataSourceName, dataSource);
        }
        return result;
    }

    protected static ShardingRuleConfiguration getShardingRuleConfiguration(Map<String, DataSource> dataSourceMap, ShardingRuleConfiguration shardingRuleConfig) {
        LinkedList<MasterSlaveRuleConfiguration> masterSlaveRuleConfigs = new LinkedList<MasterSlaveRuleConfiguration>();
        if (null == dataSourceMap || !shardingRuleConfig.getMasterSlaveRuleConfigs().isEmpty()) {
            return shardingRuleConfig;
        }
        for (DataSource each : dataSourceMap.values()) {
            if (!(each instanceof MasterSlaveDataSource)) continue;
            MasterSlaveRule masterSlaveRule = ((MasterSlaveDataSource)each).getMasterSlaveRule();
            masterSlaveRuleConfigs.add(new MasterSlaveRuleConfiguration(masterSlaveRule.getName(), masterSlaveRule.getMasterDataSourceName(), masterSlaveRule.getSlaveDataSourceNames(), masterSlaveRule.getLoadBalanceAlgorithm()));
        }
        shardingRuleConfig.setMasterSlaveRuleConfigs(masterSlaveRuleConfigs);
        return shardingRuleConfig;
    }

    public ShardingProperties getShardingProperties() {
        return this.shardingProperties;
    }
}

