/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.core.resultset;

import io.shardingsphere.core.jdbc.adapter.AbstractResultSetAdapter;
import io.shardingsphere.core.jdbc.core.resultset.ResultSetUtil;
import io.shardingsphere.core.merger.MergedResult;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;

public final class ShardingResultSet
extends AbstractResultSetAdapter {
    private final MergedResult mergeResultSet;

    public ShardingResultSet(List<ResultSet> resultSets, MergedResult mergeResultSet, Statement statement) {
        super(resultSets, statement);
        this.mergeResultSet = mergeResultSet;
    }

    @Override
    public boolean next() throws SQLException {
        return this.mergeResultSet.next();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.mergeResultSet.wasNull();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return (Boolean)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Boolean.TYPE), Boolean.TYPE);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return (Boolean)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnLabel, Boolean.TYPE), Boolean.TYPE);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return (Byte)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Byte.TYPE), Byte.TYPE);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return (Byte)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnLabel, Byte.TYPE), Byte.TYPE);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return (Short)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Short.TYPE), Short.TYPE);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return (Short)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnLabel, Short.TYPE), Short.TYPE);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return (Integer)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Integer.TYPE), Integer.TYPE);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return (Integer)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnLabel, Integer.TYPE), Integer.TYPE);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return (Long)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Long.TYPE), Long.TYPE);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return (Long)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnLabel, Long.TYPE), Long.TYPE);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return ((Float)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Float.TYPE), Float.TYPE)).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return ((Float)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnLabel, Float.TYPE), Float.TYPE)).floatValue();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return (Double)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Double.TYPE), Double.TYPE);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return (Double)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnLabel, Double.TYPE), Double.TYPE);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return (String)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, String.class), String.class);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return (String)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnLabel, String.class), String.class);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, BigDecimal.class), BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return (BigDecimal)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnLabel, BigDecimal.class), BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return (BigDecimal)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, BigDecimal.class), BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return (BigDecimal)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnLabel, BigDecimal.class), BigDecimal.class);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, byte[].class), byte[].class);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return (byte[])ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnLabel, byte[].class), byte[].class);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return (Date)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Date.class), Date.class);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return (Date)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnLabel, Date.class), Date.class);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return (Date)ResultSetUtil.convertValue(this.mergeResultSet.getCalendarValue(columnIndex, Date.class, cal), Date.class);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return (Date)ResultSetUtil.convertValue(this.mergeResultSet.getCalendarValue(columnLabel, Date.class, cal), Date.class);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return (Time)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Time.class), Time.class);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return (Time)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnLabel, Time.class), Time.class);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return (Time)ResultSetUtil.convertValue(this.mergeResultSet.getCalendarValue(columnIndex, Time.class, cal), Time.class);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return (Time)ResultSetUtil.convertValue(this.mergeResultSet.getCalendarValue(columnLabel, Time.class, cal), Time.class);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnIndex, Timestamp.class), Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return (Timestamp)ResultSetUtil.convertValue(this.mergeResultSet.getValue(columnLabel, Timestamp.class), Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return (Timestamp)ResultSetUtil.convertValue(this.mergeResultSet.getCalendarValue(columnIndex, Timestamp.class, cal), Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return (Timestamp)ResultSetUtil.convertValue(this.mergeResultSet.getCalendarValue(columnLabel, Timestamp.class, cal), Timestamp.class);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.mergeResultSet.getInputStream(columnIndex, "Ascii");
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.mergeResultSet.getInputStream(columnLabel, "Ascii");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.mergeResultSet.getInputStream(columnIndex, "Unicode");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.mergeResultSet.getInputStream(columnLabel, "Unicode");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.mergeResultSet.getInputStream(columnIndex, "Binary");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.mergeResultSet.getInputStream(columnLabel, "Binary");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return (Reader)this.mergeResultSet.getValue(columnIndex, Reader.class);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return (Reader)this.mergeResultSet.getValue(columnLabel, Reader.class);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return (Blob)this.mergeResultSet.getValue(columnIndex, Blob.class);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return (Blob)this.mergeResultSet.getValue(columnLabel, Blob.class);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return (Clob)this.mergeResultSet.getValue(columnIndex, Clob.class);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return (Clob)this.mergeResultSet.getValue(columnLabel, Clob.class);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return (URL)this.mergeResultSet.getValue(columnIndex, URL.class);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return (URL)this.mergeResultSet.getValue(columnLabel, URL.class);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return (SQLXML)this.mergeResultSet.getValue(columnIndex, SQLXML.class);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return (SQLXML)this.mergeResultSet.getValue(columnLabel, SQLXML.class);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.mergeResultSet.getValue(columnIndex, Object.class);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.mergeResultSet.getValue(columnLabel, Object.class);
    }
}

