/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.core.statement;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.executor.type.batch.BatchPreparedStatementExecutor;
import io.shardingsphere.core.executor.type.batch.BatchPreparedStatementUnit;
import io.shardingsphere.core.executor.type.prepared.PreparedStatementExecutor;
import io.shardingsphere.core.executor.type.prepared.PreparedStatementUnit;
import io.shardingsphere.core.jdbc.adapter.AbstractShardingPreparedStatementAdapter;
import io.shardingsphere.core.jdbc.core.ShardingContext;
import io.shardingsphere.core.jdbc.core.connection.ShardingConnection;
import io.shardingsphere.core.jdbc.core.resultset.GeneratedKeysResultSet;
import io.shardingsphere.core.jdbc.core.resultset.ShardingResultSet;
import io.shardingsphere.core.jdbc.metadata.ShardingConnectionTableMetaDataConnectionManager;
import io.shardingsphere.core.merger.JDBCQueryResult;
import io.shardingsphere.core.merger.MergeEngine;
import io.shardingsphere.core.merger.MergeEngineFactory;
import io.shardingsphere.core.merger.MergedResult;
import io.shardingsphere.core.merger.event.EventMergeType;
import io.shardingsphere.core.merger.event.ResultSetMergeEvent;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataConnectionManager;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataLoader;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.DALStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.DQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.routing.PreparedStatementRoutingEngine;
import io.shardingsphere.core.routing.SQLExecutionUnit;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.routing.event.EventRoutingType;
import io.shardingsphere.core.routing.event.SqlRoutingEvent;
import io.shardingsphere.core.routing.router.sharding.GeneratedKey;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.util.EventBusInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class ShardingPreparedStatement
extends AbstractShardingPreparedStatementAdapter {
    private final ShardingConnection connection;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    private final PreparedStatementRoutingEngine routingEngine;
    private final List<BatchPreparedStatementUnit> batchStatementUnits = new LinkedList<BatchPreparedStatementUnit>();
    private final Collection<PreparedStatement> routedStatements = new LinkedList<PreparedStatement>();
    private final String sql;
    private int batchCount;
    private boolean returnGeneratedKeys;
    private SQLRouteResult routeResult;
    private ResultSet currentResultSet;

    public ShardingPreparedStatement(ShardingConnection connection, String sql) {
        this(connection, sql, 1003, 1007, 1);
    }

    public ShardingPreparedStatement(ShardingConnection connection, String sql, int resultSetType, int resultSetConcurrency) {
        this(connection, sql, resultSetType, resultSetConcurrency, 1);
    }

    public ShardingPreparedStatement(ShardingConnection connection, String sql, int autoGeneratedKeys) {
        this(connection, sql);
        if (1 == autoGeneratedKeys) {
            this.returnGeneratedKeys = true;
        }
    }

    public ShardingPreparedStatement(ShardingConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.connection = connection;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.sql = sql;
        ShardingContext shardingContext = connection.getShardingContext();
        this.routingEngine = new PreparedStatementRoutingEngine(sql, shardingContext.getShardingRule(), shardingContext.getMetaData().getTable(), shardingContext.getDatabaseType(), shardingContext.isShowSQL(), shardingContext.getMetaData().getDataSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        ShardingResultSet result;
        this.routedStatements.clear();
        try {
            Collection<PreparedStatementUnit> preparedStatementUnits = this.route();
            List<ResultSet> resultSets = new PreparedStatementExecutor(this.connection.getShardingContext().getExecutorEngine(), this.routeResult.getSqlStatement().getType(), preparedStatementUnits).executeQuery();
            ArrayList<JDBCQueryResult> queryResults = new ArrayList<JDBCQueryResult>(resultSets.size());
            for (ResultSet each : resultSets) {
                queryResults.add(new JDBCQueryResult(each));
            }
            MergeEngine mergeEngine = MergeEngineFactory.newInstance((ShardingRule)this.connection.getShardingContext().getShardingRule(), queryResults, (SQLStatement)this.routeResult.getSqlStatement(), (ShardingTableMetaData)this.connection.getShardingContext().getMetaData().getTable());
            result = new ShardingResultSet(resultSets, this.merge(mergeEngine), this);
        }
        finally {
            this.clearBatch();
        }
        this.currentResultSet = result;
        return result;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.routedStatements.clear();
        try {
            Collection<PreparedStatementUnit> preparedStatementUnits = this.route();
            int n = new PreparedStatementExecutor(this.connection.getShardingContext().getExecutorEngine(), this.routeResult.getSqlStatement().getType(), preparedStatementUnits).executeUpdate();
            return n;
        }
        finally {
            this.refreshTableMetaData();
            this.clearBatch();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.routedStatements.clear();
        try {
            Collection<PreparedStatementUnit> preparedStatementUnits = this.route();
            boolean bl = new PreparedStatementExecutor(this.connection.getShardingContext().getExecutorEngine(), this.routeResult.getSqlStatement().getType(), preparedStatementUnits).execute();
            return bl;
        }
        finally {
            this.refreshTableMetaData();
            this.clearBatch();
        }
    }

    private Collection<PreparedStatementUnit> route() throws SQLException {
        LinkedList<PreparedStatementUnit> result = new LinkedList<PreparedStatementUnit>();
        this.sqlRoute();
        for (SQLExecutionUnit each : this.routeResult.getExecutionUnits()) {
            PreparedStatement preparedStatement = this.generatePreparedStatement(each);
            this.routedStatements.add(preparedStatement);
            this.replaySetParameter(preparedStatement, (List)each.getSqlUnit().getParameterSets().get(0));
            result.add(new PreparedStatementUnit(each, preparedStatement));
        }
        return result;
    }

    private PreparedStatement generatePreparedStatement(SQLExecutionUnit sqlExecutionUnit) throws SQLException {
        Connection connection = this.connection.getConnection(sqlExecutionUnit.getDataSource());
        return this.returnGeneratedKeys ? connection.prepareStatement(sqlExecutionUnit.getSqlUnit().getSql(), 1) : connection.prepareStatement(sqlExecutionUnit.getSqlUnit().getSql(), this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
    }

    private void sqlRoute() {
        SqlRoutingEvent event = new SqlRoutingEvent(this.sql);
        EventBusInstance.getInstance().post((Object)event);
        try {
            this.routeResult = this.routingEngine.route(this.getParameters());
        }
        catch (Exception ex) {
            event.setException(ex);
            event.setEventRoutingType(EventRoutingType.ROUTE_FAILURE);
            EventBusInstance.getInstance().post((Object)event);
            throw ex;
        }
        event.setEventRoutingType(EventRoutingType.ROUTE_SUCCESS);
        EventBusInstance.getInstance().post((Object)event);
    }

    private void refreshTableMetaData() {
        if (null != this.routeResult && null != this.connection && SQLType.DDL == this.routeResult.getSqlStatement().getType() && !this.routeResult.getSqlStatement().getTables().isEmpty()) {
            String logicTableName = this.routeResult.getSqlStatement().getTables().getSingleTableName();
            TableMetaDataLoader tableMetaDataLoader = new TableMetaDataLoader(this.connection.getShardingContext().getExecutorEngine().getExecutorService(), (TableMetaDataConnectionManager)new ShardingConnectionTableMetaDataConnectionManager(logicTableName, this.connection));
            this.connection.getShardingContext().getMetaData().getTable().put(logicTableName, tableMetaDataLoader.load(logicTableName, this.connection.getShardingContext().getShardingRule()));
        }
    }

    @Override
    public void clearBatch() {
        this.currentResultSet = null;
        this.clearParameters();
        this.batchStatementUnits.clear();
        this.batchCount = 0;
    }

    @Override
    public void addBatch() throws SQLException {
        try {
            for (BatchPreparedStatementUnit each : this.routeBatch()) {
                each.getStatement().addBatch();
                each.mapAddBatchCount(this.batchCount);
            }
            ++this.batchCount;
        }
        finally {
            this.currentResultSet = null;
            this.clearParameters();
        }
    }

    private List<BatchPreparedStatementUnit> routeBatch() throws SQLException {
        ArrayList<BatchPreparedStatementUnit> result = new ArrayList<BatchPreparedStatementUnit>();
        this.sqlRoute();
        for (SQLExecutionUnit each : this.routeResult.getExecutionUnits()) {
            BatchPreparedStatementUnit batchStatementUnit = this.getPreparedBatchStatement(each);
            this.replaySetParameter(batchStatementUnit.getStatement(), (List)each.getSqlUnit().getParameterSets().get(0));
            result.add(batchStatementUnit);
        }
        return result;
    }

    private BatchPreparedStatementUnit getPreparedBatchStatement(final SQLExecutionUnit sqlExecutionUnit) throws SQLException {
        Optional preparedBatchStatement = Iterators.tryFind(this.batchStatementUnits.iterator(), (Predicate)new Predicate<BatchPreparedStatementUnit>(){

            public boolean apply(BatchPreparedStatementUnit input) {
                return Objects.equals(input.getSqlExecutionUnit(), sqlExecutionUnit);
            }
        });
        if (preparedBatchStatement.isPresent()) {
            ((BatchPreparedStatementUnit)preparedBatchStatement.get()).getSqlExecutionUnit().getSqlUnit().getParameterSets().add(sqlExecutionUnit.getSqlUnit().getParameterSets().get(0));
            return (BatchPreparedStatementUnit)preparedBatchStatement.get();
        }
        BatchPreparedStatementUnit result = new BatchPreparedStatementUnit(sqlExecutionUnit, this.generatePreparedStatement(sqlExecutionUnit));
        this.batchStatementUnits.add(result);
        return result;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            int[] nArray = new BatchPreparedStatementExecutor(this.connection.getShardingContext().getExecutorEngine(), this.connection.getShardingContext().getDatabaseType(), this.routeResult.getSqlStatement().getType(), this.batchStatementUnits, this.batchCount).executeBatch();
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Optional<GeneratedKey> generatedKey = this.getGeneratedKey();
        if (this.returnGeneratedKeys && generatedKey.isPresent()) {
            return new GeneratedKeysResultSet(this.routeResult.getGeneratedKey().getGeneratedKeys().iterator(), ((GeneratedKey)generatedKey.get()).getColumn().getName(), this);
        }
        if (1 == this.routedStatements.size()) {
            return this.routedStatements.iterator().next().getGeneratedKeys();
        }
        return new GeneratedKeysResultSet();
    }

    private Optional<GeneratedKey> getGeneratedKey() {
        if (null != this.routeResult && this.routeResult.getSqlStatement() instanceof InsertStatement) {
            return Optional.fromNullable((Object)this.routeResult.getGeneratedKey());
        }
        return Optional.absent();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        if (1 == this.routedStatements.size() && this.routeResult.getSqlStatement() instanceof DQLStatement) {
            this.currentResultSet = this.routedStatements.iterator().next().getResultSet();
            return this.currentResultSet;
        }
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>(this.routedStatements.size());
        ArrayList<JDBCQueryResult> queryResults = new ArrayList<JDBCQueryResult>(this.routedStatements.size());
        for (PreparedStatement each : this.routedStatements) {
            ResultSet resultSet = each.getResultSet();
            resultSets.add(resultSet);
            queryResults.add(new JDBCQueryResult(resultSet));
        }
        if (this.routeResult.getSqlStatement() instanceof SelectStatement || this.routeResult.getSqlStatement() instanceof DALStatement) {
            MergeEngine mergeEngine = MergeEngineFactory.newInstance((ShardingRule)this.connection.getShardingContext().getShardingRule(), queryResults, (SQLStatement)this.routeResult.getSqlStatement(), (ShardingTableMetaData)this.connection.getShardingContext().getMetaData().getTable());
            this.currentResultSet = new ShardingResultSet(resultSets, this.merge(mergeEngine), this);
        }
        return this.currentResultSet;
    }

    private MergedResult merge(MergeEngine mergeEngine) throws SQLException {
        ResultSetMergeEvent event = new ResultSetMergeEvent();
        try {
            EventBusInstance.getInstance().post((Object)event);
            MergedResult result = mergeEngine.merge();
            event.setEventMergeType(EventMergeType.MERGE_SUCCESS);
            EventBusInstance.getInstance().post((Object)event);
            return result;
        }
        catch (Exception ex) {
            event.setException(ex);
            event.setEventMergeType(EventMergeType.MERGE_FAILURE);
            EventBusInstance.getInstance().post((Object)event);
            throw ex;
        }
    }

    @Override
    public ShardingConnection getConnection() {
        return this.connection;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public PreparedStatementRoutingEngine getRoutingEngine() {
        return this.routingEngine;
    }

    public List<BatchPreparedStatementUnit> getBatchStatementUnits() {
        return this.batchStatementUnits;
    }

    public Collection<PreparedStatement> getRoutedStatements() {
        return this.routedStatements;
    }

    public String getSql() {
        return this.sql;
    }

    public int getBatchCount() {
        return this.batchCount;
    }
}

