/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.core.transaction;

import io.shardingsphere.core.constant.TransactionType;
import io.shardingsphere.core.jdbc.core.transaction.WeakXaTransactionManager;
import io.shardingsphere.core.transaction.TransactionContext;
import io.shardingsphere.core.transaction.TransactionContextHolder;
import io.shardingsphere.core.transaction.event.WeakXaTransactionEvent;
import io.shardingsphere.core.transaction.event.XaTransactionEvent;
import io.shardingsphere.core.transaction.listener.TransactionListener;
import io.shardingsphere.core.transaction.spi.TransactionManager;
import io.shardingsphere.core.util.EventBusInstance;
import java.util.Iterator;
import java.util.ServiceLoader;

public final class TransactionLoader {
    public static void load() {
        TransactionContext transactionContext = TransactionContextHolder.get();
        switch (transactionContext.getTransactionType()) {
            case XA: {
                TransactionLoader.doXaTransactionConfiguration();
                break;
            }
            case BASE: {
                break;
            }
        }
        EventBusInstance.getInstance().register((Object)TransactionListener.getInstance());
    }

    private static void doXaTransactionConfiguration() {
        Iterator<TransactionManager> iterator = ServiceLoader.load(TransactionManager.class).iterator();
        TransactionContext transactionContext = iterator.hasNext() ? new TransactionContext(iterator.next(), TransactionType.XA, XaTransactionEvent.class) : new TransactionContext((TransactionManager)new WeakXaTransactionManager(), TransactionType.XA, WeakXaTransactionEvent.class);
        TransactionContextHolder.set((TransactionContext)transactionContext);
    }

    private TransactionLoader() {
    }
}

