/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.jdbc.core.transaction;

import io.shardingsphere.core.transaction.event.TransactionEvent;
import io.shardingsphere.core.transaction.event.WeakXaTransactionEvent;
import io.shardingsphere.core.transaction.spi.TransactionManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;

public final class WeakXaTransactionManager
implements TransactionManager {
    public void begin(TransactionEvent transactionEvent) throws SQLException {
        WeakXaTransactionEvent weakXaTransactionEvent = (WeakXaTransactionEvent)transactionEvent;
        for (Connection each : weakXaTransactionEvent.getCachedConnections().values()) {
            each.setAutoCommit(weakXaTransactionEvent.isAutoCommit());
        }
    }

    public void commit(TransactionEvent transactionEvent) throws SQLException {
        WeakXaTransactionEvent weakXaTransactionEvent = (WeakXaTransactionEvent)transactionEvent;
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        for (Connection each : weakXaTransactionEvent.getCachedConnections().values()) {
            try {
                each.commit();
            }
            catch (SQLException ex) {
                exceptions.add(ex);
            }
        }
        this.throwSQLExceptionIfNecessary(exceptions);
    }

    public void rollback(TransactionEvent transactionEvent) throws SQLException {
        WeakXaTransactionEvent weakXaTransactionEvent = (WeakXaTransactionEvent)transactionEvent;
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        for (Connection each : weakXaTransactionEvent.getCachedConnections().values()) {
            try {
                each.rollback();
            }
            catch (SQLException ex) {
                exceptions.add(ex);
            }
        }
        this.throwSQLExceptionIfNecessary(exceptions);
    }

    public int getStatus() {
        return 0;
    }

    private void throwSQLExceptionIfNecessary(Collection<SQLException> exceptions) throws SQLException {
        if (exceptions.isEmpty()) {
            return;
        }
        SQLException sqlException = new SQLException();
        for (SQLException each : exceptions) {
            sqlException.setNextException(each);
        }
        throw sqlException;
    }
}

