/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.merger;

import io.shardingsphere.core.merger.QueryResult;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public final class JDBCQueryResult
implements QueryResult {
    private final ResultSet resultSet;

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        Object result = Object.class == type ? this.resultSet.getObject(columnIndex) : (Boolean.TYPE == type ? Boolean.valueOf(this.resultSet.getBoolean(columnIndex)) : (Byte.TYPE == type ? Byte.valueOf(this.resultSet.getByte(columnIndex)) : (Short.TYPE == type ? Short.valueOf(this.resultSet.getShort(columnIndex)) : (Integer.TYPE == type ? Integer.valueOf(this.resultSet.getInt(columnIndex)) : (Long.TYPE == type ? Long.valueOf(this.resultSet.getLong(columnIndex)) : (Float.TYPE == type ? Float.valueOf(this.resultSet.getFloat(columnIndex)) : (Double.TYPE == type ? Double.valueOf(this.resultSet.getDouble(columnIndex)) : (String.class == type ? this.resultSet.getString(columnIndex) : (BigDecimal.class == type ? this.resultSet.getBigDecimal(columnIndex) : (byte[].class == type ? (Object)this.resultSet.getBytes(columnIndex) : (Date.class == type ? this.resultSet.getDate(columnIndex) : (Time.class == type ? this.resultSet.getTime(columnIndex) : (Timestamp.class == type ? this.resultSet.getTimestamp(columnIndex) : (URL.class == type ? this.resultSet.getURL(columnIndex) : (Blob.class == type ? this.resultSet.getBlob(columnIndex) : (Clob.class == type ? this.resultSet.getClob(columnIndex) : (SQLXML.class == type ? this.resultSet.getSQLXML(columnIndex) : (Reader.class == type ? this.resultSet.getCharacterStream(columnIndex) : this.resultSet.getObject(columnIndex)))))))))))))))))));
        return result;
    }

    public Object getValue(String columnLabel, Class<?> type) throws SQLException {
        Object result = Object.class == type ? this.resultSet.getObject(columnLabel) : (Boolean.TYPE == type ? Boolean.valueOf(this.resultSet.getBoolean(columnLabel)) : (Byte.TYPE == type ? Byte.valueOf(this.resultSet.getByte(columnLabel)) : (Short.TYPE == type ? Short.valueOf(this.resultSet.getShort(columnLabel)) : (Integer.TYPE == type ? Integer.valueOf(this.resultSet.getInt(columnLabel)) : (Long.TYPE == type ? Long.valueOf(this.resultSet.getLong(columnLabel)) : (Float.TYPE == type ? Float.valueOf(this.resultSet.getFloat(columnLabel)) : (Double.TYPE == type ? Double.valueOf(this.resultSet.getDouble(columnLabel)) : (String.class == type ? this.resultSet.getString(columnLabel) : (BigDecimal.class == type ? this.resultSet.getBigDecimal(columnLabel) : (byte[].class == type ? (Object)this.resultSet.getBytes(columnLabel) : (Date.class == type ? this.resultSet.getDate(columnLabel) : (Time.class == type ? this.resultSet.getTime(columnLabel) : (Timestamp.class == type ? this.resultSet.getTimestamp(columnLabel) : (URL.class == type ? this.resultSet.getURL(columnLabel) : (Blob.class == type ? this.resultSet.getBlob(columnLabel) : (Clob.class == type ? this.resultSet.getClob(columnLabel) : (SQLXML.class == type ? this.resultSet.getSQLXML(columnLabel) : (Reader.class == type ? this.resultSet.getCharacterStream(columnLabel) : this.resultSet.getObject(columnLabel)))))))))))))))))));
        return result;
    }

    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        if (Date.class == type) {
            return this.resultSet.getDate(columnIndex, calendar);
        }
        if (Time.class == type) {
            return this.resultSet.getTime(columnIndex, calendar);
        }
        if (Timestamp.class == type) {
            return this.resultSet.getTimestamp(columnIndex, calendar);
        }
        throw new SQLException(String.format("Unsupported type: %s", type));
    }

    public Object getCalendarValue(String columnLabel, Class<?> type, Calendar calendar) throws SQLException {
        if (Date.class == type) {
            return this.resultSet.getDate(columnLabel, calendar);
        }
        if (Time.class == type) {
            return this.resultSet.getTime(columnLabel, calendar);
        }
        if (Timestamp.class == type) {
            return this.resultSet.getTimestamp(columnLabel, calendar);
        }
        throw new SQLException(String.format("Unsupported type: %s", type));
    }

    public InputStream getInputStream(int columnIndex, String type) throws SQLException {
        switch (type) {
            case "Ascii": {
                return this.resultSet.getAsciiStream(columnIndex);
            }
            case "Unicode": {
                return this.resultSet.getUnicodeStream(columnIndex);
            }
            case "Binary": {
                return this.resultSet.getBinaryStream(columnIndex);
            }
        }
        throw new SQLException(String.format("Unsupported type: %s", type));
    }

    public InputStream getInputStream(String columnLabel, String type) throws SQLException {
        switch (type) {
            case "Ascii": {
                return this.resultSet.getAsciiStream(columnLabel);
            }
            case "Unicode": {
                return this.resultSet.getUnicodeStream(columnLabel);
            }
            case "Binary": {
                return this.resultSet.getBinaryStream(columnLabel);
            }
        }
        throw new SQLException(String.format("Unsupported type: %s", type));
    }

    public boolean wasNull() throws SQLException {
        return this.resultSet.wasNull();
    }

    public int getColumnCount() throws SQLException {
        return this.resultSet.getMetaData().getColumnCount();
    }

    public String getColumnLabel(int columnIndex) throws SQLException {
        return this.resultSet.getMetaData().getColumnLabel(columnIndex);
    }

    @ConstructorProperties(value={"resultSet"})
    public JDBCQueryResult(ResultSet resultSet) {
        this.resultSet = resultSet;
    }
}

