/*
 * Decompiled with CFR 0.152.
 */
package io.socket.socketio.server;

import io.socket.engineio.server.EngineIoSocket;
import io.socket.engineio.server.ReadyState;
import io.socket.socketio.server.SocketIoNamespace;
import io.socket.socketio.server.SocketIoNamespaceImpl;
import io.socket.socketio.server.SocketIoServer;
import io.socket.socketio.server.SocketIoSocket;
import io.socket.socketio.server.parser.IOParser;
import io.socket.socketio.server.parser.Packet;
import io.socket.socketio.server.parser.Parser;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

final class SocketIoClient {
    private final SocketIoServer mServer;
    private final EngineIoSocket mConnection;
    private final Parser.Encoder mEncoder;
    private final Parser.Decoder mDecoder;
    private final String mId;
    private final Map<String, SocketIoSocket> mSockets = new ConcurrentHashMap<String, SocketIoSocket>();
    private final Map<String, SocketIoSocket> mNamespaceSockets = new ConcurrentHashMap<String, SocketIoSocket>();

    SocketIoClient(SocketIoServer server, EngineIoSocket connection) {
        this.mServer = server;
        this.mConnection = connection;
        this.mEncoder = server.getEncoder();
        this.mDecoder = new IOParser.Decoder();
        this.mId = connection.getId();
        this.setup();
    }

    String getId() {
        return this.mId;
    }

    Map<String, String> getInitialQuery() {
        return this.mConnection.getInitialQuery();
    }

    Map<String, List<String>> getInitialHeaders() {
        return this.mConnection.getInitialHeaders();
    }

    void sendPacket(Packet<?> packet) {
        if (this.mConnection.getReadyState() == ReadyState.OPEN) {
            this.mEncoder.encode(packet, objects -> {
                for (Object item : objects) {
                    io.socket.engineio.server.parser.Packet engineIoPacket = new io.socket.engineio.server.parser.Packet("message");
                    engineIoPacket.data = item;
                    this.mConnection.send(engineIoPacket);
                }
            });
        }
    }

    void connect(String namespace, Object data) {
        if (this.mServer.hasNamespace(namespace) || this.mServer.checkNamespace(namespace)) {
            this.doConnect(namespace, data);
        } else {
            JSONObject errorData = new JSONObject();
            try {
                errorData.put("message", (Object)"Invalid namespace");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            Packet packet = new Packet(4);
            packet.nsp = namespace;
            packet.data = errorData;
            this.sendPacket(packet);
        }
    }

    void remove(SocketIoSocket socket) {
        if (this.mSockets.containsValue((Object)socket)) {
            SocketIoNamespace namespace = socket.getNamespace();
            this.mSockets.remove(socket.getId());
            this.mNamespaceSockets.remove(namespace.getName());
        }
    }

    void disconnect() {
        for (SocketIoSocket socket : this.mSockets.values()) {
            socket.disconnect(false);
        }
        this.mSockets.clear();
        this.close();
    }

    EngineIoSocket getConnection() {
        return this.mConnection;
    }

    private void close() {
        if (this.mConnection.getReadyState() == ReadyState.OPEN) {
            this.mConnection.close();
            this.onClose("forced server close");
        }
    }

    private void setup() {
        this.mDecoder.onDecoded(packet -> {
            if (packet.type == 0) {
                if (this.mConnection.getProtocolVersion() == 3) {
                    String namespace = packet.nsp;
                    String queryString = null;
                    if (namespace.contains("?")) {
                        queryString = namespace.substring(namespace.indexOf(63) + 1);
                        namespace = namespace.substring(0, namespace.indexOf(63));
                    }
                    this.connect(namespace, queryString);
                } else {
                    this.connect(packet.nsp, packet.data);
                }
            } else {
                SocketIoSocket socket = this.mNamespaceSockets.get(packet.nsp);
                if (socket != null) {
                    socket.onPacket(packet);
                }
            }
        });
        this.mConnection.on("data", args -> {
            try {
                Object data = args[0];
                if (data instanceof String) {
                    this.mDecoder.add((String)data);
                } else if (data instanceof byte[]) {
                    this.mDecoder.add((byte[])data);
                }
            }
            catch (Exception ex) {
                this.onError(ex.getMessage());
            }
        });
        this.mConnection.on("error", args -> this.onError((String)args[0]));
        this.mConnection.on("close", args -> this.onClose((String)args[0]));
        this.mServer.getScheduledExecutor().schedule(() -> {
            if (this.mNamespaceSockets.isEmpty()) {
                this.close();
            }
        }, this.mServer.getOptions().getConnectionTimeout(), TimeUnit.MILLISECONDS);
    }

    private void destroy() {
        this.mConnection.off("data");
        this.mConnection.off("error");
        this.mConnection.off("close");
    }

    private void doConnect(String namespace, Object data) {
        SocketIoNamespaceImpl nsp = (SocketIoNamespaceImpl)this.mServer.namespace(namespace);
        SocketIoSocket socket = nsp.add(this, data);
        this.mSockets.put(socket.getId(), socket);
        this.mNamespaceSockets.put(namespace, socket);
    }

    private void onClose(String reason) {
        this.destroy();
        for (SocketIoSocket socket : this.mSockets.values()) {
            socket.onClose(reason);
        }
        this.mSockets.clear();
        this.mDecoder.destroy();
    }

    private void onError(String error) {
        for (SocketIoSocket socket : this.mSockets.values()) {
            socket.onError(error);
        }
        this.mConnection.close();
    }
}

