/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import springfox.documentation.annotations.Incubating;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.builders.CollectionSpecificationBuilder;
import springfox.documentation.builders.CompoundModelSpecificationBuilder;
import springfox.documentation.builders.MapSpecificationBuilder;
import springfox.documentation.builders.ModelFacetsBuilder;
import springfox.documentation.builders.NoopValidator;
import springfox.documentation.builders.ReferenceModelSpecificationBuilder;
import springfox.documentation.builders.ValidationResult;
import springfox.documentation.builders.Validator;
import springfox.documentation.schema.CollectionSpecification;
import springfox.documentation.schema.CompoundModelSpecification;
import springfox.documentation.schema.MapSpecification;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.ReferenceModelSpecification;
import springfox.documentation.schema.ScalarModelSpecification;
import springfox.documentation.schema.ScalarType;

public class ModelSpecificationBuilder {
    private ModelFacetsBuilder facetsBuilder;
    private String name;
    private ScalarModelSpecification scalar;
    private CollectionSpecificationBuilder collection;
    private MapSpecificationBuilder map;
    private ReferenceModelSpecificationBuilder referenceModel;
    private CompoundModelSpecificationBuilder compoundModelBuilder;
    private final Validator<ModelSpecificationBuilder> validator = this::validateSpecification;

    public ModelSpecificationBuilder name(@NonNull String name) {
        this.name = BuilderDefaults.defaultIfAbsent(name, this.name);
        return this;
    }

    public ModelSpecificationBuilder facets(@NonNull Consumer<ModelFacetsBuilder> facets) {
        if (this.facetsBuilder == null) {
            this.facetsBuilder = new ModelFacetsBuilder();
        }
        facets.accept(this.facetsBuilder);
        return this;
    }

    public ModelSpecificationBuilder scalarModel(ScalarType type) {
        if (type != null) {
            this.scalar = new ScalarModelSpecification(type);
        }
        return this;
    }

    private CompoundModelSpecificationBuilder compoundModelBuilder() {
        if (this.compoundModelBuilder == null) {
            this.compoundModelBuilder = new CompoundModelSpecificationBuilder();
        }
        return this.compoundModelBuilder;
    }

    public ModelSpecificationBuilder compoundModel(@NonNull Consumer<CompoundModelSpecificationBuilder> compound) {
        compound.accept(this.compoundModelBuilder());
        return this;
    }

    public ModelSpecificationBuilder compoundModelIfExists(@NonNull Consumer<CompoundModelSpecificationBuilder> compound) {
        if (this.compoundModelBuilder != null) {
            compound.accept(this.compoundModelBuilder);
        } else {
            CompoundModelSpecificationBuilder throwAwayBuilder = new CompoundModelSpecificationBuilder();
            compound.accept(throwAwayBuilder);
        }
        return this;
    }

    public ModelSpecificationBuilder collectionModel(@NonNull Consumer<CollectionSpecificationBuilder> consumer) {
        consumer.accept(this.collectionBuilder());
        return this;
    }

    public ModelSpecificationBuilder collectionModelIfExists(@NonNull Consumer<CollectionSpecificationBuilder> consumer) {
        if (this.collection != null) {
            consumer.accept(this.collection);
        } else {
            CollectionSpecificationBuilder throwAwayBuilder = new CollectionSpecificationBuilder();
            consumer.accept(throwAwayBuilder);
        }
        return this;
    }

    private CollectionSpecificationBuilder collectionBuilder() {
        if (this.collection == null) {
            this.collection = new CollectionSpecificationBuilder();
        }
        return this.collection;
    }

    public ModelSpecificationBuilder mapModel(@NonNull Consumer<MapSpecificationBuilder> consumer) {
        consumer.accept(this.mapBuilder());
        return this;
    }

    public ModelSpecificationBuilder mapModelIfExists(@NonNull Consumer<MapSpecificationBuilder> consumer) {
        if (this.map != null) {
            consumer.accept(this.map);
        } else {
            MapSpecificationBuilder throwAwayBuilder = new MapSpecificationBuilder();
            consumer.accept(throwAwayBuilder);
        }
        return this;
    }

    private MapSpecificationBuilder mapBuilder() {
        if (this.map == null) {
            this.map = new MapSpecificationBuilder();
        }
        return this.map;
    }

    public ModelSpecificationBuilder referenceModel(Consumer<ReferenceModelSpecificationBuilder> consumer) {
        consumer.accept(this.referenceModelBuilder());
        return this;
    }

    public ModelSpecificationBuilder referenceModelIfExists(Consumer<ReferenceModelSpecificationBuilder> consumer) {
        if (this.referenceModel != null) {
            consumer.accept(this.referenceModel);
        } else {
            ReferenceModelSpecificationBuilder throwAwayBuilder = new ReferenceModelSpecificationBuilder();
            consumer.accept(throwAwayBuilder);
        }
        return this;
    }

    private ReferenceModelSpecificationBuilder referenceModelBuilder() {
        if (this.referenceModel == null) {
            this.referenceModel = new ReferenceModelSpecificationBuilder();
        }
        return this.referenceModel;
    }

    public ModelSpecificationBuilder copyOf(@Nullable ModelSpecification other) {
        if (other != null) {
            ScalarType scalar = other.getScalar().map(ScalarModelSpecification::getType).orElse(null);
            ReferenceModelSpecification reference = other.getReference().orElse(null);
            CompoundModelSpecification compound = other.getCompound().orElse(null);
            CollectionSpecification collection = other.getCollection().orElse(null);
            MapSpecification map = other.getMap().orElse(null);
            this.scalar = null;
            this.map = null;
            this.collection = null;
            this.referenceModel = null;
            this.compoundModelBuilder = new CompoundModelSpecificationBuilder();
            this.name(other.getName()).scalarModel(scalar).referenceModel(r -> r.copyOf(reference)).compoundModel(cm -> cm.copyOf(compound)).collectionModel(c -> c.copyOf(collection)).mapModel(m -> m.copyOf(map)).facets(f -> f.copyOf(other.getFacets().orElse(null)));
        }
        return this;
    }

    private List<ValidationResult> validateSpecification(ModelSpecificationBuilder builder) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        long specCount = Stream.of(this.scalar, this.safeCompoundModelBuild(), this.safeCollectionBuild(), this.safeMapBuild(), this.safeReferenceBuild()).filter(Objects::nonNull).count();
        if (specCount == 0L) {
            validationResults.add(new ValidationResult("ModelSpecification", "spec", "At least one type of specification is required"));
        }
        if (specCount > 1L) {
            validationResults.add(new ValidationResult("ModelSpecification", "spec", "Only one of the specifications should be non null"));
        }
        return validationResults;
    }

    private Object safeCompoundModelBuild() {
        return this.compoundModelBuilder != null ? this.compoundModelBuilder.build() : null;
    }

    private Object safeCollectionBuild() {
        return this.collection != null ? this.collection.build() : null;
    }

    private Object safeMapBuild() {
        return this.map != null ? this.map.build() : null;
    }

    private Object safeReferenceBuild() {
        return this.referenceModel != null ? this.referenceModel.build() : null;
    }

    @Incubating(value="3.0.0")
    public ModelSpecificationBuilder maybeConvertToScalar(ScalarType scalar) {
        this.scalarModel(scalar);
        if (this.compoundModelBuilder != null) {
            this.compoundModelBuilder = null;
        }
        if (this.collection != null) {
            this.collection = null;
        }
        return this;
    }

    public ModelSpecification build() {
        CompoundModelSpecification compoundModel = this.compoundModelBuilder != null ? this.compoundModelBuilder.build() : null;
        List<ValidationResult> results = this.validator.validate(this);
        if (NoopValidator.logProblems(results).size() > 0) {
            return null;
        }
        return new ModelSpecification(this.name, this.facetsBuilder != null ? this.facetsBuilder.build() : null, this.scalar, compoundModel, this.collection != null ? this.collection.build() : null, this.map != null ? this.map.build() : null, this.referenceModel != null ? this.referenceModel.build() : null);
    }
}

