/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.fasterxml.classmate.ResolvedType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import springfox.documentation.builders.ModelSpecificationBuilder;
import springfox.documentation.schema.ModelKey;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.QualifiedModelName;
import springfox.documentation.service.ModelNamesRegistry;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ModelNamesRegistryFactoryPlugin;
import springfox.documentation.spi.service.contexts.ModelSpecificationRegistry;

public class DefaultModelNamesRegistryFactory
implements ModelNamesRegistryFactoryPlugin {
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public ModelNamesRegistry modelNamesRegistry(ModelSpecificationRegistry registry) {
        return new DefaultModelNamesRegistry(registry);
    }

    private static class DefaultModelNamesRegistry
    implements ModelNamesRegistry {
        private final ModelSpecificationRegistry modelRegistry;
        private final Map<ModelKey, String> modelStems = new HashMap<ModelKey, String>();
        private final Map<Set<ResolvedType>, String> validationSuffixes = new HashMap<Set<ResolvedType>, String>();
        private final Map<ModelKey, String> requestResponseSuffixes = new HashMap<ModelKey, String>();
        private final Map<ModelKey, String> modelKeyToName;

        DefaultModelNamesRegistry(ModelSpecificationRegistry modelRegistry) {
            this.modelRegistry = modelRegistry;
            modelRegistry.modelKeys().forEach(this::processKeys);
            this.modelKeyToName = modelRegistry.modelKeys().stream().collect(Collectors.toMap(Function.identity(), k -> String.format("%s%s%s", this.modelStems.get(k), this.validationSuffixes.getOrDefault(k.getValidationGroupDiscriminators(), ""), this.requestResponseSuffixes.getOrDefault(k, ""))));
            this.adjustForNameCollisions();
        }

        private void adjustForNameCollisions() {
            LinkedMultiValueMap nameToKey = new LinkedMultiValueMap();
            this.modelKeyToName.forEach((arg_0, arg_1) -> DefaultModelNamesRegistry.lambda$adjustForNameCollisions$1((MultiValueMap)nameToKey, arg_0, arg_1));
            nameToKey.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).forEach(e -> {
                Map<QualifiedModelName, String> nameToSuffix = this.nameSuffixLookup((Map.Entry<String, List<ModelKey>>)e);
                ((List)e.getValue()).forEach(modelKey -> this.modelKeyToName.put((ModelKey)modelKey, String.format("%s%s", this.modelKeyToName.get(modelKey), nameToSuffix.getOrDefault(modelKey.getQualifiedModelName(), ""))));
            });
        }

        private Map<QualifiedModelName, String> nameSuffixLookup(Map.Entry<String, List<ModelKey>> e) {
            HashMap<QualifiedModelName, String> modelSuffix = new HashMap<QualifiedModelName, String>();
            Set distinctModels = e.getValue().stream().map(ModelKey::getQualifiedModelName).collect(Collectors.toSet());
            if (distinctModels.size() > 1) {
                int index = 0;
                for (QualifiedModelName key : distinctModels) {
                    int modelIndex = index++;
                    modelSuffix.putIfAbsent(key, String.valueOf(modelIndex));
                }
            }
            return modelSuffix;
        }

        private void processKeys(ModelKey modelKey) {
            int modelIndex;
            boolean hasRequestResponsePair = this.modelRegistry.hasRequestResponsePairs(modelKey);
            Collection validationModels = this.modelRegistry.modelsDifferingOnlyInValidationGroups(modelKey);
            Collection sameNameDifferentNamespace = this.modelRegistry.modelsWithSameNameAndDifferentNamespace(modelKey);
            int index = 0;
            for (ModelKey key : sameNameDifferentNamespace) {
                modelIndex = index++;
                this.modelStems.computeIfAbsent(key, k -> String.format("%s%s", k.getQualifiedModelName().getName(), modelIndex));
            }
            this.modelStems.computeIfAbsent(modelKey, k -> k.getQualifiedModelName().getName());
            index = 0;
            for (ModelKey key : validationModels) {
                modelIndex = index++;
                this.validationSuffixes.computeIfAbsent(key.getValidationGroupDiscriminators(), k -> modelIndex == 0 ? "" : "_" + modelIndex);
            }
            if (hasRequestResponsePair) {
                this.requestResponseSuffixes.computeIfAbsent(modelKey, k -> k.isResponse() ? "Res" : "Req");
            } else if (modelKey.getViewDiscriminator().isPresent()) {
                this.requestResponseSuffixes.putIfAbsent(modelKey, ((ResolvedType)modelKey.getViewDiscriminator().get()).getErasedType().getSimpleName() + "View");
            }
        }

        public Map<String, ModelSpecification> modelsByName() {
            HashMap<String, ModelSpecification> map = new HashMap<String, ModelSpecification>();
            this.modelKeyToName.forEach((key, value) -> map.putIfAbsent((String)value, new ModelSpecificationBuilder().copyOf(this.modelRegistry.modelSpecificationFor(key)).facets(f -> f.title(value)).build()));
            return map;
        }

        public Optional<String> nameByKey(ModelKey key) {
            return Optional.ofNullable(this.modelKeyToName.get(key));
        }

        private static /* synthetic */ void lambda$adjustForNameCollisions$1(MultiValueMap nameToKey, ModelKey k, String v) {
            nameToKey.add((Object)v, (Object)k);
        }
    }
}

