/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowMessages;
import io.undertow.conduits.ConduitListener;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class FixedLengthStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private final ConduitListener<? super FixedLengthStreamSourceConduit> finishListener;
    private long state;
    private static final long FLAG_CLOSED = Long.MIN_VALUE;
    private static final long FLAG_FINISHED = 0x4000000000000000L;
    private static final long FLAG_LENGTH_CHECKED = 0x2000000000000000L;
    private static final long MASK_COUNT = Bits.longBitMask((int)0, (int)60);
    private final HttpServerExchange exchange;

    public FixedLengthStreamSourceConduit(StreamSourceConduit next, long contentLength, ConduitListener<? super FixedLengthStreamSourceConduit> finishListener, HttpServerExchange exchange) {
        super(next);
        this.finishListener = finishListener;
        if (contentLength < 0L) {
            throw new IllegalArgumentException("Content length must be greater than or equal to zero");
        }
        if (contentLength > MASK_COUNT) {
            throw new IllegalArgumentException("Content length is too long");
        }
        this.state = contentLength;
        this.exchange = exchange;
    }

    public FixedLengthStreamSourceConduit(StreamSourceConduit next, long contentLength, ConduitListener<? super FixedLengthStreamSourceConduit> finishListener) {
        this(next, contentLength, finishListener, null);
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long l;
        long val = this.state;
        this.checkMaxSize(val);
        if (Bits.anyAreSet((long)val, (long)-4611686018427387904L) || Bits.allAreClear((long)val, (long)MASK_COUNT)) {
            if (Bits.allAreClear((long)val, (long)0x4000000000000000L)) {
                this.invokeFinishListener();
            }
            return -1L;
        }
        long res = 0L;
        Throwable transferError = null;
        try {
            l = res = ((StreamSourceConduit)this.next).transferTo(position, Math.min(count, val & MASK_COUNT), target);
        }
        catch (IOException | Error | RuntimeException e) {
            try {
                IoUtils.safeClose((Closeable)((Object)this.exchange.getConnection()));
                transferError = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.exitRead(res, transferError);
                throw throwable;
            }
        }
        this.exitRead(res, transferError);
        return l;
    }

    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        if (count == 0L) {
            return 0L;
        }
        long val = this.state;
        this.checkMaxSize(val);
        if (Bits.anyAreSet((long)val, (long)-4611686018427387904L) || Bits.allAreClear((long)val, (long)MASK_COUNT)) {
            if (Bits.allAreClear((long)val, (long)0x4000000000000000L)) {
                this.invokeFinishListener();
            }
            return -1L;
        }
        long res = 0L;
        Throwable transferError = null;
        try {
            long l = res = ((StreamSourceConduit)this.next).transferTo(Math.min(count, val & MASK_COUNT), throughBuffer, target);
            return l;
        }
        catch (IOException | Error | RuntimeException e) {
            IoUtils.safeClose((Closeable)((Object)this.exchange.getConnection()));
            transferError = e;
            throw e;
        }
        finally {
            this.exitRead(res + (long)throughBuffer.remaining(), transferError);
        }
    }

    private void checkMaxSize(long state) throws IOException {
        if (Bits.anyAreClear((long)state, (long)0x2000000000000000L)) {
            HttpServerExchange exchange = this.exchange;
            if (exchange != null && exchange.getMaxEntitySize() > 0L && exchange.getMaxEntitySize() < (state & MASK_COUNT)) {
                Connectors.terminateRequest(exchange);
                exchange.setPersistent(false);
                this.finishListener.handleEvent(this);
                this.state |= 0xC000000000000000L;
                throw UndertowMessages.MESSAGES.requestEntityWasTooLarge(exchange.getMaxEntitySize());
            }
            this.state |= 0x2000000000000000L;
        }
    }

    /*
     * Exception decompiling
     */
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    /*
     * Exception decompiling
     */
    public int read(ByteBuffer dst) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isReadResumed() {
        return Bits.allAreClear((long)this.state, (long)Long.MIN_VALUE) && ((StreamSourceConduit)this.next).isReadResumed();
    }

    public void wakeupReads() {
        long val = this.state;
        if (Bits.anyAreSet((long)val, (long)-4611686018427387904L)) {
            return;
        }
        ((StreamSourceConduit)this.next).wakeupReads();
    }

    public void terminateReads() throws IOException {
        long val = this.enterShutdownReads();
        if (Bits.allAreSet((long)val, (long)Long.MIN_VALUE)) {
            return;
        }
        this.exitShutdownReads(val);
    }

    public void awaitReadable() throws IOException {
        long val = this.state;
        if (Bits.allAreSet((long)val, (long)Long.MIN_VALUE) || val == 0L) {
            return;
        }
        ((StreamSourceConduit)this.next).awaitReadable();
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        long val = this.state;
        if (Bits.allAreSet((long)val, (long)Long.MIN_VALUE) || val == 0L) {
            return;
        }
        try {
            ((StreamSourceConduit)this.next).awaitReadable(time, timeUnit);
        }
        catch (IOException | Error | RuntimeException e) {
            IoUtils.safeClose((Closeable)((Object)this.exchange.getConnection()));
            throw e;
        }
    }

    public long getRemaining() {
        return this.state & MASK_COUNT;
    }

    private long enterShutdownReads() {
        long newVal;
        long oldVal = this.state;
        if (Bits.anyAreSet((long)oldVal, (long)Long.MIN_VALUE)) {
            return oldVal;
        }
        this.state = newVal = oldVal | Long.MIN_VALUE;
        return oldVal;
    }

    private void exitShutdownReads(long oldVal) {
        if (!Bits.allAreClear((long)oldVal, (long)MASK_COUNT)) {
            this.invokeFinishListener();
        }
    }

    private void exitRead(long consumed, Throwable readError) throws IOException {
        long newVal;
        long oldVal = this.state;
        if (consumed == -1L) {
            if (Bits.anyAreSet((long)oldVal, (long)MASK_COUNT)) {
                this.invokeFinishListener();
                this.state &= MASK_COUNT ^ 0xFFFFFFFFFFFFFFFFL;
                IOException couldNotReadAll = UndertowMessages.MESSAGES.couldNotReadContentLengthData();
                if (readError != null) {
                    couldNotReadAll.addSuppressed(readError);
                }
                throw couldNotReadAll;
            }
            return;
        }
        this.state = newVal = oldVal - consumed;
    }

    private void invokeFinishListener() {
        this.state |= 0x4000000000000000L;
        this.finishListener.handleEvent(this);
    }
}

