/*
 * Decompiled with CFR 0.152.
 */
package brave.httpclient;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.execchain.ClientExecChain;

final class TracingProtocolExec
implements ClientExecChain {
    final Tracer tracer;
    final HttpClientHandler<brave.http.HttpClientRequest, brave.http.HttpClientResponse> handler;
    final ClientExecChain protocolExec;

    TracingProtocolExec(HttpTracing httpTracing, ClientExecChain protocolExec) {
        this.tracer = httpTracing.tracing().tracer();
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing);
        this.protocolExec = protocolExec;
    }

    /*
     * Loose catch block
     */
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext clientContext, HttpExecutionAware execAware) throws IOException, HttpException {
        CloseableHttpResponse closeableHttpResponse;
        Tracer.SpanInScope ws;
        Throwable error;
        HttpClientResponse response;
        Span span;
        block10: {
            span = this.handler.nextSpan((Object)new HttpClientRequest((HttpRequest)request));
            response = null;
            error = null;
            ws = this.tracer.withSpanInScope(span);
            CloseableHttpResponse result = this.protocolExec.execute(route, request, clientContext, execAware);
            response = new HttpClientResponse((HttpResponse)result);
            closeableHttpResponse = result;
            if (ws == null) break block10;
            ws.close();
        }
        this.handler.handleReceive((Object)response, error, span);
        return closeableHttpResponse;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (ws != null) {
                            try {
                                ws.close();
                            }
                            catch (Throwable throwable2) {
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | Error | RuntimeException | HttpException e) {
                        error = e;
                        throw e;
                    }
                }
                catch (Throwable throwable3) {
                    this.handler.handleReceive(response, error, span);
                    throw throwable3;
                }
            }
        }
    }

    static final class HttpClientResponse
    extends brave.http.HttpClientResponse {
        final HttpResponse delegate;

        HttpClientResponse(HttpResponse delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public int statusCode() {
            StatusLine statusLine = this.delegate.getStatusLine();
            return statusLine != null ? statusLine.getStatusCode() : 0;
        }
    }

    static final class HttpClientRequest
    extends brave.http.HttpClientRequest {
        final HttpRequest delegate;

        HttpClientRequest(HttpRequest delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.getRequestLine().getMethod();
        }

        public String path() {
            String result = this.delegate.getRequestLine().getUri();
            int begin = result.lastIndexOf(47);
            int queryIndex = result.indexOf(63);
            return queryIndex == -1 ? result.substring(begin) : result.substring(begin, queryIndex);
        }

        public String url() {
            HttpRequestWrapper wrapper;
            HttpHost target;
            if (this.delegate instanceof HttpRequestWrapper && (target = (wrapper = (HttpRequestWrapper)this.delegate).getTarget()) != null) {
                return target.toURI() + wrapper.getURI();
            }
            return this.delegate.getRequestLine().getUri();
        }

        public String header(String name) {
            Header result = this.delegate.getFirstHeader(name);
            return result != null ? result.getValue() : null;
        }

        public void header(String name, String value) {
            this.delegate.setHeader(name, value);
        }
    }
}

